#include <vcl.h>
#pragma hdrstop

#include "Main.h"

#pragma package(smart_init)
#pragma resource "*.dfm"

TMainForm *MainForm;


__fastcall TMainForm::TMainForm(TComponent* Owner) : TForm(Owner)
   {
   Caption = Application->Title;

   Application->OnIdle = OnIdle;

   MsgMemo->Lines->Text = MainMarquee->Lines->Text;

   AlignCB->ItemIndex = MainMarquee->Alignment;
   LayoutCB->ItemIndex = MainMarquee->Layout;
   DirCB->ItemIndex = MainMarquee->Direction;
   IntervalUpDown->Position = MainMarquee->Interval;
   RepUpDown->Position = MainMarquee->Repetitions;
   WordWrapChk->Checked = MainMarquee->WordWrap;

   SBMarquee->Active = true;
   DirCBChange(0);
   MainMarquee->Active = true;
   }

void __fastcall TMainForm::CloseBtnClick(TObject *Sender)
   {
   Close();
   }

void __fastcall TMainForm::MsgMemoChange(TObject *Sender)
   {
   MainMarquee->Lines->Text = MsgMemo->Lines->Text;
   }

void __fastcall TMainForm::StartBtnClick(TObject *Sender)
   {
   MainMarquee->Active = !MainMarquee->Active;
   TRect cr = MainMarquee->ClientRect;
   }

void __fastcall TMainForm::FontBtnClick(TObject *Sender)
   {
   FontDialog->Font = MainMarquee->Font;
   if (FontDialog->Execute()) MainMarquee->Font = FontDialog->Font;
   }

void __fastcall TMainForm::ColorBtnClick(TObject *Sender)
   {
   ColorDialog->Color = MainMarquee->Color;
   if (ColorDialog->Execute()) MainMarquee->Color = ColorDialog->Color;
   }

void __fastcall TMainForm::AlignCBChange(TObject *Sender)
   {                                        
   MainMarquee->Alignment = (TAlignment)AlignCB->ItemIndex;
   }

void __fastcall TMainForm::LayoutCBChange(TObject *Sender)
   {                                                            
   MainMarquee->Layout = (TTextLayout)LayoutCB->ItemIndex;
   }

void __fastcall TMainForm::DirCBChange(TObject *Sender)
   {
   MainMarquee->Direction = (TMarqueeDir)DirCB->ItemIndex;
   if (MainMarquee->Direction == mqLeft || MainMarquee->Direction == mqRight)
      {
      AlignCB->Enabled = false;
      LayoutCB->Enabled = true;
      }
   else
      {
      AlignCB->Enabled = true;
      LayoutCB->Enabled = false;
      }
   }

void __fastcall TMainForm::IntervalEditChange(TObject *Sender)
   {
   MainMarquee->Interval = IntervalUpDown->Position;
   }

void __fastcall TMainForm::RepEditChange(TObject *Sender)
   {
   MainMarquee->Repetitions = RepUpDown->Position;
   }

void __fastcall TMainForm::OnIdle(TObject* Sender, bool &Done)
   {
   if (MainMarquee->Active)
      {
      StartBtn->Caption = "Stop";
      CenterBtn->Enabled = false;
      }
   else
      {
      StartBtn->Caption = "Start";
      CenterBtn->Enabled = true;
      }

   if (SBMarquee->Active)
      {
      SBMarquee->Hint = "Double-click to stop";
      StartItem->Caption = "&Stop";
      }
   else
      {
      SBMarquee->Hint = "Double-click to start";
      StartItem->Caption = "&Start";
      }
   }

void __fastcall TMainForm::SBMarqueeDblClick(TObject *Sender)
   {
   SBMarquee->Active = !SBMarquee->Active;
   }

void __fastcall TMainForm::TextItemClick(TObject *Sender)
   {
   String text = SBMarquee->Lines->Text;
   if (InputQuery(Caption, "Text", text)) SBMarquee->Lines->Text = text;
   }

void __fastcall TMainForm::WordWrapChkClick(TObject *Sender)
   {
   MainMarquee->WordWrap = WordWrapChk->Checked;
   }

void __fastcall TMainForm::CenterBtnClick(TObject *Sender)
   {
   MainMarquee->Center();
   }

