#include <vcl.h>
#pragma hdrstop

#include "Marquee.h"
#pragma package(smart_init)


__fastcall TMarquee::TMarquee(TComponent* Owner) : TGraphicControl(Owner)
   {
   direction = mqLeft;
   layout = tlCenter;
   alignment = taCenter;
   repetitions = 0;
   wordWrap = false;

   work = new Graphics::TBitmap();
   work->Canvas->Brush->Color = clWindow;

   lines = new TStringList;
   lines->OnChange = OnLinesChange;
   work->Canvas->Font->OnChange = OnFontChange;

   timer = new TTimer(this);
   timer->Enabled = false;
   timer->Interval = 50;
   timer->OnTimer = OnTimer;

   Width = 150;
   Height = work->Canvas->TextHeight("Wj");
   MeasureText();

   xpos = 0, ypos = 0;
   }

__fastcall TMarquee::~TMarquee()
   {
   delete lines;
   delete work;
   }

void TMarquee::Center()
   {
   if (direction == mqLeft || direction == mqRight)
      {
      xpos = max(0, (Width - textWidth) / 2);
      }
   else
      {
      ypos = max(0, (Height - textHeight) / 2);
      }

   if (Visible)
      Paint();
   }

bool __fastcall TMarquee::GetActive()
   {
   return(timer->Enabled);
   }

void __fastcall TMarquee::SetActive(bool active)
   {
   timer->Enabled = active;
   if (active) repCount = 0;
   }

void __fastcall TMarquee::SetAlignment(TAlignment aAlignment)
   {
   alignment = aAlignment;
   Paint();
   }

TColor __fastcall TMarquee::GetColor()
   {
   return(work->Canvas->Brush->Color);
   }

void __fastcall TMarquee::SetColor(TColor color)
   {
   work->Canvas->Brush->Color = color;
   Paint();
   }

void __fastcall TMarquee::SetDirection(TMarqueeDir dir)
   {
   if (dir == direction) return;

   direction = dir;
   Paint();
   }

TFont * __fastcall TMarquee::GetFont()
   {
   return(work->Canvas->Font);
   }

void __fastcall TMarquee::SetFont(TFont *font)
   {
   work->Canvas->Font->Assign(font);
   MeasureText();
   Paint();
   }

int __fastcall TMarquee::GetInterval()
   {
   return(timer->Interval);
   }

void __fastcall TMarquee::SetInterval(int interval)
   {
   timer->Interval = interval;
   }

void __fastcall TMarquee::SetLayout(TTextLayout aLayout)
   {
   layout = aLayout;
   Paint();
   }

void __fastcall TMarquee::SetLines(TStringList *list)
   {
   lines->Assign(list);
   MeasureText();
   Paint();
   }

void __fastcall TMarquee::SetRepetitions(int reps)
   {
   repetitions = reps;
   repCount = 0;
   }

void __fastcall TMarquee::SetWordWrap(bool wrap)
   {
   if (wrap == wordWrap) return;

   wordWrap = wrap;
   MeasureText();
   Paint();
   }

void __fastcall TMarquee::SetName(const AnsiString Value)
   {
   if (Lines->Text == Name) Lines->Text = Value;
   TGraphicControl::SetName(Value);
   }

void __fastcall TMarquee::Paint(void)
   {
   work->Width = Width;
   work->Height = Height;

   UINT format = wordWrap ? DT_WORDBREAK : 0;

   TRect r;
   r.Left = 0;
   r.Top = 0;
   r.Right = Width;
   r.Bottom = 0;
   if (direction == mqLeft || direction == mqRight)
      {
      r.Left = xpos;

      r.Top = 0;
      if (layout == tlCenter)
         r.Top = (Height - textHeight) / 2;
      else if (layout == tlBottom)
         r.Top = Height - textHeight;

      r.Right = r.Left + textWidth;
      }
   else
      {
      r.Left = 0;
      if (alignment == taCenter)
         format |= DT_CENTER;
      else if (alignment == taRightJustify)
         format |= DT_RIGHT;

      r.Top = ypos;

      r.Right = Width;
      }

   r.Bottom = r.Top + textHeight;

   TRect s;
   s.Left = 0;
   s.Top = 0;
   s.Right = work->Width;
   s.Bottom = work->Height;
   work->Canvas->FillRect(s);

   DrawText(work->Canvas->Handle, lines->Text.c_str(), -1, (RECT*)&r, format);

   Canvas->CopyRect(s, work->Canvas, s);
   }

void __fastcall TMarquee::MeasureText()
   {
   int lineHeight = work->Canvas->TextHeight("Wj");

   TRect r;
   r.Left = 0;
   r.Top = 0;
   r.Right = Width;
   r.Bottom = 0;
   if (wordWrap)
      {
      textHeight = DrawText(work->Canvas->Handle, lines->Text.c_str(), -1, (RECT*)&r, DT_CALCRECT | DT_WORDBREAK);
      textHeight -= lineHeight;
      textWidth = r.Right;
      }
   else
      {
      textWidth = textHeight = 0;
      for (int i = 0; i < lines->Count; i++)
         textWidth = max(textWidth, work->Canvas->TextWidth(lines->Strings[i]));
      textHeight = lineHeight * lines->Count;
      }
   }

void __fastcall TMarquee::Move()
   {
   switch(direction)
      {
      case mqLeft:
         if (xpos < -textWidth)
            {
            xpos = Width;
            if (repetitions > 0) repCount++;
            }
         else
            xpos--;
         break;

      case mqRight:
         if (xpos > Width)
            {
            xpos = -textWidth;
            if (repetitions > 0) repCount++;
            }
         else
            xpos++;
         break;

      case mqUp:
         if (ypos < -textHeight)
            {
            ypos = Height;
            if (repetitions > 0) repCount++;
            }
         else
            ypos--;
         break;

      case mqDown:
         if (ypos > Height)
            {
            ypos = -textHeight;
            if (repetitions > 0) repCount++;
            }
         else
            ypos++;
         break;
      }

   if (repetitions > 0 && repCount == repetitions)
      Active = false;
   else if (Visible)
      Paint();
   }

void __fastcall TMarquee::OnFontChange(TObject *Sender)
   {
   MeasureText();
   Paint();
   }

void __fastcall TMarquee::OnLinesChange(TObject *Sender)
   {
   MeasureText();
   Paint();
   }

void __fastcall TMarquee::OnTimer(TObject *Sender)
   {
   Move();
   }

void __fastcall TMarquee::Loaded(void)
   {
   MeasureText();
   TGraphicControl::Loaded();
   }

//---------------------------------------------------------------------------

namespace Marquee
   {
   void __fastcall PACKAGE Register()
      {
      TComponentClass classes[1] = {__classid(TMarquee)};
      RegisterComponents("BCBJournal", classes, 0);
      }
   }


//---------------------------------------------------------------------------

static inline void ValidCtrCheck(TMarquee *)
   {
   new TMarquee(NULL);
   }

