#ifndef MarqueeH
#define MarqueeH

#include <SysUtils.hpp>
#include <Controls.hpp>
#include <Classes.hpp>
#include <Forms.hpp>

enum TMarqueeDir {mqLeft, mqRight, mqUp, mqDown};

class PACKAGE TMarquee : public TGraphicControl
   {
   __published:
      __property Align;
#if (__BORLANDC__ > 0x530)
      __property Anchors;
      __property Constraints;
      __property DragKind;
      __property DragMode;
      __property OnContextPopup;
      __property OnEndDock;
      __property OnStartDock;
#endif
      __property Cursor;
      __property DragCursor;
      __property Enabled;
      __property Height;
      __property Hint;
      __property Left;
      __property Name;
      __property PopupMenu;
      __property ShowHint;
      __property Tag;
      __property Top;
      __property Visible;
      __property Width;

      __property OnClick;
      __property OnDblClick;
      __property OnDragDrop;
      __property OnDragOver;
      __property OnEndDrag;
      __property OnMouseDown;
      __property OnMouseMove;
      __property OnMouseUp;
      __property OnStartDrag;

      __property bool Active = {read = GetActive, write = SetActive, default = false};
      __property TAlignment Alignment = {read = alignment, write = SetAlignment, default = taCenter};
      __property TColor Color = {read = GetColor, write = SetColor, default = clWindow};
      __property TMarqueeDir Direction = {read = direction, write = SetDirection, default = mqLeft};
      __property TFont *Font = {read = GetFont, write = SetFont};
      __property int Interval = {read = GetInterval, write = SetInterval, default = 50};
      __property TTextLayout Layout = {read = layout, write = SetLayout, default = tlCenter};
      __property TStringList *Lines = {read = lines, write = SetLines};
      __property int Repetitions = {read = repetitions, write = SetRepetitions, default = 0};
      __property bool WordWrap = {read = wordWrap, write = SetWordWrap, default = false};

   public:
      __fastcall TMarquee(TComponent* Owner);
      virtual __fastcall ~TMarquee();

      void Center();

   private:
      bool __fastcall GetActive();
      void __fastcall SetActive(bool active);
      void __fastcall SetAlignment(TAlignment aAlignment);
      TColor __fastcall GetColor();
      void __fastcall SetColor(TColor color);
      void __fastcall SetDirection(TMarqueeDir dir);
      TFont * __fastcall GetFont();
      void __fastcall SetFont(TFont *font);
      int __fastcall GetInterval();
      void __fastcall SetInterval(int interval);
      void __fastcall SetLayout(TTextLayout aLayout);
      void __fastcall SetLines(TStringList *list);
      void __fastcall SetRepetitions(int reps);
      void __fastcall SetWordWrap(bool wrap);

      virtual void __fastcall SetName(const AnsiString Value);

      virtual void __fastcall Paint();
      void __fastcall MeasureText();
      void __fastcall Move();

      void __fastcall OnFontChange(TObject *Sender);
      void __fastcall OnLinesChange(TObject *Sender);
      virtual void __fastcall OnTimer(TObject *Sender);

      virtual void __fastcall Loaded(void);

      Graphics::TBitmap *work;
      TTimer *timer;

      TAlignment alignment;
      TMarqueeDir direction;
      TTextLayout layout;
      TStringList *lines;
      int repetitions, repCount;
      bool wordWrap;

      int xpos, ypos;
      int textWidth, textHeight;
   };


#endif   // MarqueeH
