
//===========================================================================
#ifndef COLORBUTTON_H
#define COLORBUTTON_H
//===========================================================================

#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <memory>
//---------------------------------------------------------------------------

#if (__BORLANDC__ < 0x0530)
   #define DYNAMIC
   #define PACKAGE
#endif

class TColorButton : public TButton
{
public:
  __fastcall TColorButton(TComponent* Owner);

__published:
  __property TColor Color =
    {read = GetColor, write = SetColor};
  __property TColor ColorLo =
    {read = ColorLo_, write = SetColorLo,
     default = clBtnShadow};
  __property TColor ColorHi =
    {read = ColorHi_, write = SetColorHi,
     default = clBtnHighlight};

protected:
  // inherited member functions
  virtual void __fastcall CreateParams(
    TCreateParams& Params);
  virtual void __fastcall SetButtonStyle(
    bool ADefault);

  // introduced member functions
  virtual void __fastcall DoDrawButtonFace(
    const TOwnerDrawState& state);
  virtual void __fastcall DoDrawButtonText(
    const TOwnerDrawState& state);

private:
  TColor ColorLo_;
  TColor ColorHi_;
  std::auto_ptr<TCanvas> Canvas_;
  bool draw_as_default_;

  TColor __fastcall GetColor();
  void __fastcall SetColor(TColor Value);
  void __fastcall SetColorLo(TColor Value);
  void __fastcall SetColorHi(TColor Value);

  MESSAGE void __fastcall CNDrawItem(TMessage& Msg);
  MESSAGE void __fastcall WMLButtonDblClk(
    TMessage& Msg);
  MESSAGE void __fastcall CMFontChanged(
    TMessage& Msg);
  MESSAGE void __fastcall CMEnabledChanged(
    TMessage& Msg);

public:
BEGIN_MESSAGE_MAP
  MESSAGE_HANDLER(
    CN_DRAWITEM, TMessage, CNDrawItem)
  MESSAGE_HANDLER(
    WM_LBUTTONDBLCLK, TMessage, WMLButtonDblClk)
  MESSAGE_HANDLER(
    CM_FONTCHANGED, TMessage, CMFontChanged)
  MESSAGE_HANDLER(
    CM_ENABLEDCHANGED, TMessage, CMEnabledChanged)
END_MESSAGE_MAP(TButton)
};

//===========================================================================
#endif // COLORBUTTON_H
//===========================================================================

