
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "OwnerDrawButton.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

__fastcall TForm1::TForm1(
  TComponent* Owner) : TForm(Owner)
{
  hODButton_ = CreateWindowEx(
    0, "BUTTON", "ODButton1",
    WS_CHILD | WS_VISIBLE | BS_OWNERDRAW,
    10, 10, 125, 30,
    Handle, NULL, HInstance, NULL
    );
}
//---------------------------------------------------------------------------

void __fastcall TForm1::
  WMDrawItem(TMessage& Msg)
{
  // grab a pointer to the DRAWITEMSTRUCT
  const DRAWITEMSTRUCT* pDrawItem =
    reinterpret_cast<DRAWITEMSTRUCT*>
      (Msg.LParam);

  // if the message is from our button...
  if (pDrawItem->hwndItem == hODButton_)
  {
    // grab a handle to the target DC
    const HDC hButtonDC = pDrawItem->hDC;

    // extract the target rectangle
    RECT RButton = pDrawItem->rcItem;

    // is the button pushed?
    const bool is_pushed =
      pDrawItem->itemState & ODS_SELECTED;
    // does the button have focus?
    const bool is_focused =
      pDrawItem->itemState & ODS_FOCUS;

    //
    // set the rendering flags to draw
    // a regular push button, and adjust
    // the rendering flags according to
    // the button's current state
    //
    unsigned int flags = DFCS_BUTTONPUSH;
    if (is_pushed) flags |= DFCS_PUSHED;

    //
    // render the push button by using
    // the DrawFrameControl() function
    //
    DrawFrameControl(
      hButtonDC, &RButton,
      DFC_BUTTON, flags
      );

    //
    // render the button's text...
    //
    RECT RButtonText = RButton;
    if (is_pushed)
    {
      OffsetRect(&RButtonText, 1, 1);
    }
    DrawText(
      hButtonDC, "ODButton1\0", -1,
      &RButtonText, DT_CENTER |
      DT_VCENTER | DT_SINGLELINE
      );

    //
    // indicate keyboard focus (here via
    // an etched edge rather than the
    // traditional focus rectangle)
    //
    if (is_focused)
    {
      InflateRect(&RButton, -4, -4);
      DrawEdge(
        hButtonDC, &RButton,
        EDGE_ETCHED, BF_RECT
        );
    }

    // return TRUE for this message
    Msg.Result = TRUE;
  }
  // otherwise, pass the message along
  else TForm::Dispatch(&Msg);
}
//---------------------------------------------------------------------------



