
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit_LVThumb.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

__fastcall TForm1::TForm1
  (TComponent* Owner) : TForm(Owner),
  LVCanvas_(new TCanvas())
{
}
//---------------------------------------------------------------------------

bool IsItemVisible(
   TListItem& Item
  )
{
  RECT ROverlap;
  const RECT RItem =
    Item.DisplayRect(drBounds);
  const RECT RView =
    Item.ListView->ClientRect;
    
  return IntersectRect(
    &ROverlap, &RView, &RItem
    );
}
//--------------------------------------------------------------------------

void __fastcall
  TForm1::WMNotify(TMessage& Msg)
{
  // get the NMHDR info
  const NMHDR* phdr =
    reinterpret_cast<NMHDR*>(Msg.LParam);

  // if the msg is a Custom Draw msg
  // and it's from the list view...
  TListView& LV = *ListView1;
  if (phdr->code == NM_CUSTOMDRAW &&
      phdr->hwndFrom == LV.Handle)
  {
    // get the Custom Draw info
    const NMCUSTOMDRAW* pcd =
      reinterpret_cast<NMCUSTOMDRAW*>
        (Msg.LParam);
        
    // test the drawing stage...
    switch (pcd->dwDrawStage)
    {
      case CDDS_PREPAINT:
      {
        // tell the list view that we
        // want notification of each
        // item that needs to be drawn
        Msg.Result = CDRF_NOTIFYITEMDRAW;
        return;
      }
      case CDDS_ITEMPREPAINT:
      {
        // extract the item index
        const int item_index =
          pcd->dwItemSpec;
          
        // grab a pointer to the item
        TListItem* pItem =
          LV.Items->Item[item_index];
        assert(pItem != NULL);

        // if the list item isn't visible
        if (!IsItemVisible(*pItem))
        {
          // there's nothing to draw
          Msg.Result = CDRF_SKIPDEFAULT;
          return;
        }

        try
        {
          // save the DC's defaults
          SaveDC(pcd->hdc);
          // attach the DC to LVCanvas
          LVCanvas_->Handle = pcd->hdc;

          // draw the thumbnail frame
          DoDrawThumb(pcd, *pItem);
        }
        __finally
        {
          // detach the DC from LVCanvas_        
          LVCanvas_->Handle = NULL;
          // restore the DC's defaults
          RestoreDC(pcd->hdc, -1);
        }
        
        // tell the list view to
        // draw the item's captions
        Msg.Result = CDRF_DODEFAULT;
        return;
      }
    }
  }
  // pass other messages on
  TForm::Dispatch(&Msg);
}
//---------------------------------------------------------------------------

void TForm1::DoDrawThumb(
  const NMCUSTOMDRAW* pcd,
  TListItem& Item
  )
{
  // grab a reference to the list view
  TListView& LV = *ListView1;

  // get the item's thumbnail rect
  TRect RIcon = Item.DisplayRect(drIcon);
  InflateRect(&RIcon, -6, -6);
  OffsetRect(&RIcon, -1, -1);

  //
  // draw the thumbnail frame...
  //
  // right & bottom black border
  LVCanvas_->Pen->Width = 1;
  LVCanvas_->Pen->Color = clBlack;
  const TPoint PDarkBorder[] = {
    Point(RIcon.Right, RIcon.Top),
    Point(RIcon.Right, RIcon.Bottom),
    Point(RIcon.Left, RIcon.Bottom)
    };
  LVCanvas_->Polyline(PDarkBorder, 2);
  //
  // left & top gray border
  LVCanvas_->Pen->Color = clGray;
  const TPoint PMedBorder[] = {
    Point(RIcon.Left, RIcon.Bottom),
    Point(RIcon.Left, RIcon.Top),
    Point(RIcon.Right, RIcon.Top)
    };
  LVCanvas_->Polyline(PMedBorder, 2);
  //
  // bottom & right light-gray border
  LVCanvas_->Pen->Color = clSilver;
  const TPoint PLiteBorder[] = {
    Point(RIcon.Left+1, RIcon.Bottom-1),
    Point(RIcon.Right-1, RIcon.Bottom-1),
    Point(RIcon.Right-1, RIcon.Top)
    };
  LVCanvas_->Polyline(PLiteBorder, 2);

  //
  // draw the selected/hot outline...
  //
  HDC hDC = NULL, hOldDC = NULL;
  if (
    LVCanvas_->ClipRect.top > RIcon.top
    )
  {
    hOldDC = LVCanvas_->Handle;
    hDC = GetDC(LV.Handle);
    LVCanvas_->Handle = hDC;
  }
  LVCanvas_->Pen->Width = 3;
  LVCanvas_->Brush->Style = bsClear;
  try
  {
    const bool is_sel =
      pcd->uItemState & CDIS_SELECTED;
    const bool is_hot =
      pcd->uItemState & CDIS_HOT;

    LVCanvas_->Pen->Color =
      (is_sel && is_hot) ? clHotLight :
      is_sel ? clHighlight : LV.Color;

    OffsetRect(&RIcon, 1, 1);
    InflateRect(&RIcon, 4, 4);
    LVCanvas_->Rectangle(RIcon);
  }
  __finally
  {
    if (hDC != NULL && hOldDC != NULL)
    {
      LVCanvas_->Handle = hOldDC;
      ReleaseDC(LV.Handle, hDC);
    }
  }
}
//---------------------------------------------------------------------------


