
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit_LVThumb.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

__fastcall TForm1::TForm1
  (TComponent* Owner) : TForm(Owner),
  LVCanvas_(new TCanvas())
{
  img_path_ = "small_images/";
  EnumerateImages();
}
//---------------------------------------------------------------------------

void TForm1::ClearContainers()
{
  // clear the current list of indices
  indices_.clear();

  // clear the current list of bitmaps
  const TBitmaps::iterator
    bmp_end = bmps_.end();
  for (
    TBitmaps::iterator bmp =
    bmps_.begin(); bmp != bmp_end; ++bmp
    )
  {
    delete (*bmp).second;
  }
  bmps_.clear();
}
//---------------------------------------------------------------------------

void TForm1::EnumerateImages()
{
  // empty bmps_ and indices_
  ClearContainers();

  // fill the list view...
  TSearchRec sr;
  std::memset(
    &sr, 0, sizeof(TSearchRec)
    );
  ListView1->Items->BeginUpdate();
  try
  {
    ListView1->Clear();
    const int res = FindFirst(
      img_path_ + "*.bmp", faAnyFile, sr
      );
    if (res == 0)
    {
      do
      {
      	TListItem* pItem =
          ListView1->Items->Add();
        pItem->Caption = sr.Name;
      }
      while (FindNext(sr) == 0);
    }
  }
  __finally
  {
    FindClose(sr);
    ListView1->Items->EndUpdate();
  }
}
//---------------------------------------------------------------------------


bool IsItemVisible(
   TListItem& Item
  )
{
  RECT ROverlap;
  const RECT RItem =
    Item.DisplayRect(drBounds);
  const RECT RView =
    Item.ListView->ClientRect;
    
  return IntersectRect(
    &ROverlap, &RView, &RItem
    );
}
//--------------------------------------------------------------------------

void __fastcall
  TForm1::WMNotify(TMessage& Msg)
{
  // get the NMHDR info
  const NMHDR* phdr =
    reinterpret_cast<NMHDR*>(Msg.LParam);

  // if the msg is a Custom Draw msg
  // and it's from the list view...
  TListView& LV = *ListView1;
  if (phdr->code == NM_CUSTOMDRAW &&
      phdr->hwndFrom == LV.Handle)
  {
    // get the Custom Draw info
    const NMCUSTOMDRAW* pcd =
      reinterpret_cast<NMCUSTOMDRAW*>
        (Msg.LParam);
  
    // test the drawing stage...
    switch (pcd->dwDrawStage)
    {
      case CDDS_PREPAINT:
      {
        // tell the list view that we
        // want notification of each
        // item that needs to be drawn
        Msg.Result = CDRF_NOTIFYITEMDRAW;
        return;
      }
      case CDDS_ITEMPREPAINT:
      {
        // extract the item index
        const int item_index =
          pcd->dwItemSpec;
          
        // grab a pointer to the item
        TListItem* pItem =
          LV.Items->Item[item_index];
        assert(pItem != NULL);

        // if the list item isn't visible
        if (!IsItemVisible(*pItem))
        {
          // there's nothing to draw
          Msg.Result = CDRF_SKIPDEFAULT;
          break;
        }
        
        try
        {
          // save the DC's defaults
          SaveDC(pcd->hdc);
          // attach the DC to LVCanvas_
          LVCanvas_->Handle = pcd->hdc;

          // draw the thumbnail frame
          DoDrawThumb(
            pcd, *pItem, true
            );

          // is the image in the map?
          const bool img_loaded =
            bmps_.find(pItem->Caption) !=
            bmps_.end();
            
          // if the image is loaded...
          if (img_loaded)
          {
            // draw the image...
            DoDrawImg(*pItem);
          }
          else // otherwise...
          {
            // queue the item
            DoQueueImg(item_index);
          }
        }
        __finally
        {
          // detach the DC from LVCanvas_        
          LVCanvas_->Handle = NULL;
          // restore the DC's defaults
          RestoreDC(pcd->hdc, -1);
        }
        Msg.Result = CDRF_DODEFAULT;
        return;
      }
    }
  }
  TForm::Dispatch(&Msg);
}
//---------------------------------------------------------------------------

void TForm1::DoDrawThumb(
  const NMCUSTOMDRAW* pcd,
  TListItem& Item,  
  bool img_loaded
  )
{
  // grab a reference to the list view
  TListView& LV = *ListView1;

  // get the item's thumbnail rect
  TRect RIcon = Item.DisplayRect(drIcon);
  InflateRect(&RIcon, -6, -6);
  OffsetRect(&RIcon, -1, -1);

  //
  // draw the thumbnail frame...
  //
  // right & bottom black border
  LVCanvas_->Pen->Width = 1;
  LVCanvas_->Pen->Color = clBlack;
  const TPoint PDarkBorder[] = {
    Point(RIcon.Right, RIcon.Top),
    Point(RIcon.Right, RIcon.Bottom),
    Point(RIcon.Left, RIcon.Bottom)
    };
  LVCanvas_->Polyline(PDarkBorder, 2);
  //
  // left & top gray border
  LVCanvas_->Pen->Color = clGray;
  const TPoint PMedBorder[] = {
    Point(RIcon.Left, RIcon.Bottom),
    Point(RIcon.Left, RIcon.Top),
    Point(RIcon.Right, RIcon.Top)
    };
  LVCanvas_->Polyline(PMedBorder, 2);
  //
  // bottom & right light-gray border
  LVCanvas_->Pen->Color = clSilver;
  const TPoint PLiteBorder[] = {
    Point(RIcon.Left+1, RIcon.Bottom-1),
    Point(RIcon.Right-1, RIcon.Bottom-1),
    Point(RIcon.Right-1, RIcon.Top)
    };
  LVCanvas_->Polyline(PLiteBorder, 2);

  // draw the status text
  if (!img_loaded)
  {
    const AnsiString text("Loading...");
    DrawText(
      LVCanvas_->Handle, text.c_str(),
      text.Length(), &RIcon, DT_CENTER |
      DT_VCENTER | DT_SINGLELINE
      );
  }

  //
  // draw the selected/hot outline...
  //
  HDC hDC = NULL, hOldDC = NULL;
  if (
    LVCanvas_->ClipRect.top > RIcon.top
    )
  {
    hOldDC = LVCanvas_->Handle;
    hDC = GetDC(LV.Handle);
    LVCanvas_->Handle = hDC;
  }

  LVCanvas_->Pen->Width = 3;
  LVCanvas_->Brush->Style = bsClear;
  try
  {
    const bool is_sel =
      pcd->uItemState & CDIS_SELECTED;
    const bool is_hot =
      pcd->uItemState & CDIS_HOT;

    LVCanvas_->Pen->Color =
      (is_sel && is_hot) ? clHotLight :
      is_sel ? clHighlight : LV.Color;

    OffsetRect(&RIcon, 1, 1);
    InflateRect(&RIcon, 4, 4);
    LVCanvas_->Rectangle(RIcon);
  }
  __finally
  {
    if (hDC != NULL && hOldDC != NULL)
    {
      LVCanvas_->Handle = hOldDC;
      ReleaseDC(LV.Handle, hDC);
    }
  }
}
//---------------------------------------------------------------------------

void TForm1::DoDrawImg(
   TListItem& Item
  )
{
  // get the list item's thumbnail rect
  TRect RItem = Item.DisplayRect(drIcon);
  InflateRect(&RItem, -7, -7);
  OffsetRect(&RItem, -1, -1);

  // get the associated bitmap
  Graphics::TBitmap& Bitmap =
    *bmps_[Item.Caption];

  // compute some dimensions
  const SIZE SBmp = {
    Bitmap.Width, Bitmap.Height
    };
  const int dX =
    (RItem.right - RItem.left) - SBmp.cx;
  const int dY =
    (RItem.bottom - RItem.top) - SBmp.cy;

  // if the drawing rect's width is
  // larger than the bitmap's width...
  if (dX > 0)
  {
    // center the image horizontally
    RItem.left += 0.5 * dX;
    RItem.right = RItem.left + SBmp.cx;
  }
  
  // if the drawing rect's height is
  // larger than the bitmap's height...
  if (dY > 0)
  {
    // center the image vertically
    RItem.top += 0.5 * dY;
    RItem.bottom = RItem.top + SBmp.cy;
  }

  // draw the bitmap
  LVCanvas_->Draw(
    RItem.left, RItem.top, &Bitmap
    );
}
//---------------------------------------------------------------------------

void TForm1::DoQueueImg(
   int item_index
  )
{
  // is the item already queued?
  const bool queued = std::find(
    indices_.begin(), indices_.end(),
    item_index
    ) != indices_.end();

  // if not queued...
  if (!queued)
  {
    // add the item index to the queue
    indices_.push_back(item_index);
    
    // fire-off the timer
    Timer1->Enabled = true;
  }
}
//---------------------------------------------------------------------------

void __fastcall
  TForm1::Timer1Timer(TObject *Sender)
{
  // if some items are queued...
  bool defer_next_item = false;
  while (!defer_next_item)
  {
    if (indices_.empty()) break;

    // grab the next queued list item
    TListItem* pItem = ListView1->
      Items->Item[indices_.front()];
    assert(pItem != NULL);

    // if the item is visible...
    if (IsItemVisible(*pItem))
    {
      // load the item's image
      DoLoadImg(*pItem);
      // defer loading the next item
      // until the timer fires again
      defer_next_item = true;
    }
    else // otherwise...
    {
      // move to the next item
      defer_next_item = false;
    }

    // remove the item's index
    indices_.pop_front();
  }

  // if there's no more queued items...
  if (!defer_next_item)
  {
    // disable the timer
    Timer1->Enabled = false;
  }
}
//---------------------------------------------------------------------------

void TForm1::DoLoadImg(
   TListItem& Item
  )
{
  // get the item's thumbnail dimensions
  TRect RItem = Item.DisplayRect(drIcon);
  InflateRect(&RItem, -7, -7);
  OffsetRect(&RItem, -1, -1);  

  // load the bitmap
  const AnsiString
    img_name(Item.Caption);
  std::auto_ptr<Graphics::TBitmap>
    pBmp(new Graphics::TBitmap());
  try
  {
    pBmp->LoadFromFile(
      img_path_ + img_name
      );
  }
  catch (...) {
    // eat the exception
  }

  // grab the bitmap's dimensions
  SIZE SBmp =
    {pBmp->Width, pBmp->Height};

  // if the bitmap has zero dimensions
  // (i.e., the bitmap wasn't loaded)...
  if (SBmp.cx == 0 || SBmp.cy == 0)
  {
    // resize the image
    pBmp->PixelFormat = pf8bit;
    pBmp->Width =
      RItem.right - RItem.left;
    pBmp->Height =
      RItem.bottom - RItem.top;

    // indicate an unknown format
    TRect RText = Rect(
      0, 0, pBmp->Width, pBmp->Height
      );
    DrawText(
      pBmp->Canvas->Handle, "<?>", 3,
      &RText, DT_CENTER | DT_VCENTER |
      DT_SINGLELINE
      );
  }
  else // otherwise...
  {
    //
    // resize the bitmap to fit
    // in the thumbnail frame...
    //
    const int dX = SBmp.cx -
      (RItem.right - RItem.left);
    const int dY = SBmp.cy -
      (RItem.bottom - RItem.top);

    // if the bitmap is too large...
    if (dX > 0 || dY > 0)
    {
      // define the new bitmap dimensions
      // (maintaining the aspect ratio)
      if (dX > dY)
      {
        const float shrink_factor = 1.0 -
          dX/static_cast<float>(SBmp.cx);
        SBmp.cx -= dX;
        SBmp.cy *= shrink_factor;
      }
      else
      {
        const float shrink_factor = 1.0 -
          dY/static_cast<float>(SBmp.cy);
        SBmp.cy -= dY;
        SBmp.cx *= shrink_factor;
      }

      // resize the bitmap
      const HBITMAP hBmp =
        pBmp->ReleaseHandle();
      const HBITMAP hNewBmp = CopyImage(
        hBmp, IMAGE_BITMAP, SBmp.cx,
        SBmp.cy, LR_COPYDELETEORG |
        LR_CREATEDIBSECTION
        );
      if (hNewBmp == NULL)
      {
        DeleteObject(hBmp);
      }
      pBmp->Handle = hNewBmp;
    }
  }

  // add the bitmap to the map
  bmps_[img_name] = pBmp.release();

  // update the list item's display
  InvalidateRect(
    Item.ListView->Handle, &RItem, true
    );
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Choosefolder1Click(TObject *Sender)
{
  const bool res = SelectDirectory(
    "Choose image folder...", "",
    img_path_
    );
  if (res)
  {
    img_path_ += "/";
    EnumerateImages();
  }
}
//---------------------------------------------------------------------------

