
//---------------------------------------------------------------------------
#ifndef Unit_LVThumbH
#define Unit_LVThumbH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ImgList.hpp>
#include <FileCtrl.hpp>
#include <ExtCtrls.hpp>
#include <Menus.hpp>
//---------------------------------------------------------------------------

#include <map>
#include <deque>
#include <memory>
#include <cassert>
//---------------------------------------------------------------------------

class TForm1 : public TForm
{
typedef std::map
  <AnsiString, Graphics::TBitmap*> TBitmaps;
typedef std::deque<int> TIndices;

__published:
  TListView *ListView1;
  TImageList *ImageList1;
  TTimer *Timer1;
  TMainMenu *MainMenu1;
  TMenuItem *Choosefolder1;
  void __fastcall Timer1Timer(TObject *Sender);
  void __fastcall Choosefolder1Click(TObject *Sender);

private:
  TBitmaps bmps_;
  TIndices indices_;
  AnsiString img_path_;
  std::auto_ptr<TCanvas> LVCanvas_;

  void EnumerateImages();
  void ClearContainers();

  void DoDrawThumb(const NMCUSTOMDRAW* pcd,
    TListItem& Item, bool img_loaded);

  void DoLoadImg(TListItem& Item);
  void DoDrawImg(TListItem& Item);
  void DoQueueImg(int item_index);

  // WM_NOTIFY message handler
  MESSAGE void __fastcall WMNotify(TMessage& Msg);

public:
  __fastcall TForm1(TComponent* Owner);
  __fastcall ~TForm1() { ClearContainers(); }

BEGIN_MESSAGE_MAP
  // map WM_NOTIFY to the WMNotify() method
  MESSAGE_HANDLER(WM_NOTIFY, TMessage, WMNotify)
END_MESSAGE_MAP(TForm)
};

//---------------------------------------------------------------------------
extern PACKAGE TForm1 *Form1;
//---------------------------------------------------------------------------
#endif
