
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

enum TTreeCheckState
  {tcNone, tcUnchecked, tcChecked};

TTreeCheckState GetNodeCheckState(
   TTreeNode& Node
  )
{
  return static_cast<TTreeCheckState>
    (Node.StateIndex);
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void SetNodeCheckState(
   TTreeNode& Node,
   TTreeCheckState state
  )
{
  Node.StateIndex = state;
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void ToggleNodeCheckState(
   TTreeNode& Node
  )
{
  SetNodeCheckState(
    Node, (GetNodeCheckState(Node) == tcChecked) ?
    tcUnchecked : tcChecked
    );
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~



__fastcall TForm1::TForm1(TComponent* Owner)
   : TForm(Owner)
{
}
//---------------------------------------------------------------------------

// TreeView1's OnMouseDown event handler
void __fastcall TForm1::
  TreeView1MouseDown(TObject *Sender,
  TMouseButton Button, TShiftState Shift,
  int X, int Y)
{
  if (Button != mbLeft) return;

  const THitTests hit =
    TreeView1->GetHitTestInfoAt(X, Y);
  if (hit.Contains(htOnStateIcon))
  {
    TTreeNode* SelNode =
      TreeView1->Selected;
    if (SelNode != NULL)
    {
      ToggleNodeCheckState(*SelNode);
    }
  }
}
//---------------------------------------------------------------------------

// TreeView1's OnKeyPress event handler
void __fastcall TForm1::TreeView1KeyPress
  (TObject *Sender, char &Key)
{
  if (Key == ' ')
  {
    TTreeNode* SelNode =
      TreeView1->Selected;
    if (SelNode != NULL)
    {
      ToggleNodeCheckState(*SelNode);
      Key = 0;
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  TTreeNode* SelNode =
    TreeView1->Selected;
  if (SelNode != NULL)
  {
    ToggleNodeCheckState(*SelNode);
  }
}
//---------------------------------------------------------------------------

