
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <commctrl.h>
#include <cassert>
#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

enum TTreeCheckState
  {tcNone, tcUnchecked, tcChecked};

TTreeCheckState GetNodeCheckState(
   TTreeNode& Node
  )
{
  static TVITEM tvi = {TVIF_HANDLE | TVIF_STATE};
  tvi.hItem = Node.ItemId;
  tvi.stateMask = TVIS_STATEIMAGEMASK;
  assert(TreeView_GetItem(Node.Handle, &tvi));
    
  return static_cast<TTreeCheckState>
    (tvi.state >> 12);
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void SetNodeCheckState(
   TTreeNode& Node,
   TTreeCheckState state
  )
{
  static TVITEM tvi = {TVIF_HANDLE | TVIF_STATE};
  tvi.hItem = Node.ItemId;
  tvi.stateMask = TVIS_STATEIMAGEMASK;
  tvi.state = INDEXTOSTATEIMAGEMASK(
    static_cast<int>(state)
    );
  assert(TreeView_SetItem(Node.Handle, &tvi));
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void ToggleNodeCheckState(
   TTreeNode& Node
  )
{
  SetNodeCheckState(
    Node, (GetNodeCheckState(Node) == tcChecked) ?
    tcUnchecked : tcChecked
    );
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void SetCheckBoxesStyle(
   TTreeView& TreeView
  )
{
  const HWND hTree = TreeView.Handle;
  const LONG res = SetWindowLong(
    hTree, GWL_STYLE,
    GetWindowLong(hTree, GWL_STYLE) |
    TVS_CHECKBOXES
    );
  assert(res != 0);
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

void FreeStateImageList(
   TTreeView& TreeView
  )
{
  const HIMAGELIST hImgList =
    TreeView_GetImageList(
      TreeView.Handle, TVSIL_STATE
      );
  if (hImgList != NULL)
  {
    ImageList_Destroy(hImgList);
  }
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

__fastcall TForm1::TForm1(
  TComponent* Owner) : TForm(Owner)
{
  SetCheckBoxesStyle(*TreeView1);
}
//---------------------------------------------------------------------------

__fastcall TForm1::~TForm1()
{
  FreeStateImageList(*TreeView1);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  SetNodeCheckState(
    *TreeView1->Selected, tcChecked
    );
}
//---------------------------------------------------------------------------


