#include <vcl.h>
#pragma hdrstop

#include "Main.h"
#include "NumToWords.h"

#pragma package(smart_init)
#pragma resource "*.dfm"

TMainForm *MainForm;

__fastcall TMainForm::TMainForm(TComponent* Owner) : TForm(Owner)
   {
   Caption = Application->Title;
   NumEdit->Text = 18446744073709551615;
   }

void __fastcall TMainForm::NumEditChange(TObject *Sender)
   {
   String max("18446744073709551615");
   String s, r(NumEdit->Text);

   bool neg = false;
   if (r.Length() > 1 && r[1] == '-') neg = true;

   for (int i = neg ? 2 : 1; i <= r.Length(); i++)
      if (r[i] >= '0' && r[i] <= '9') s += r[i];

   WordMemo->Text = "";
   if (s.Length() > max.Length() || (s.Length() == max.Length() && s > max))
      {
      String msg = "This number is too " + String(neg == true ? "small" : "large") + ".";
      WordMemo->Text = msg;
      FormatMemo->Text = msg;
      return;
      }

   BIGNUM number = (BIGNUM)(_atoi64(s.c_str()));

   if (neg) WordMemo->Text = "negative-";
   WordMemo->Text = WordMemo->Text + NumToWords(number);

   FormatMemo->Text = String(neg == true ? "-" : "") + FormatFloat("#,##0", number);

   if (number > 999999999999999999)
      {
      String msg = "\r\nFormatFloat() does not work as expected on numbers this ";
      msg += String(neg == true ? "small" : "large") + ".";
      FormatMemo->Lines->Add(msg);
      }
   }

void __fastcall TMainForm::OKBtnClick(TObject *Sender)
   {
   Close();
   }

