#pragma hdrstop

#include "NumToWords.h"

// From _lim.h ---------------------------------------
// -9223372036854775806 minimum signed __int64 value
//  9223372036854775807 maximum signed __int64 value
// 18446744073709551615 maximum unsigned __int64 value


String sep("-");
String neg("negative");
char *set1[20] = {"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "ninteen"};
char *set2[11] = {"zero", "ten", "twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety", "hundred"};
char *set3[7] ={"", "thousand", "million", "billion", "trillion", "quadrillion", "quintillion"};

String NumToWords(BIGNUM num)
   {
   if (num == 0) return(set1[0]);

   String result;

   if (num < 0)
      {
      result += neg + sep;
      num = -num;
      }

   int g = 0, n;
   BIGNUM t = 1;
   for (BIGNUM x = num; x >= 1000; x /= 1000) g++, t *= 1000;

   for (; g >= 0; g--, t /= 1000)
      {
      if (num < t) continue;

      n = (num / t) / 100;
      if (n > 0)
         {
         result += String(set1[n]) + sep + set2[10];

         num -= n * 100 * t;

         if (num != 0) result += sep;
         }

      n = (num / t) / 10;
      if (n > 1)
         {
         result += String(set2[n]);

         num -= n * 10 * t;

         if (num != 0) result += sep;
         }

      n = num / t;
      if (n > 0)
         {
         result += String(set1[n]);

         num -= n * t;
         }

      if (g > 0) result += sep + set3[g];

      if (num != 0) result += sep;
      }

   return(result);
   }


#pragma package(smart_init)
