//
//  Description:
//
//    This is a sample application that calculates the CRC-32
//    for the data within a file.
//
//  Author:
//
//    John M. Miano miano@colosseumbuilders.com
//
//  Date:
//
//    25-April-1999
//
//  Usage:
//
//    FILECRC input-filename
//

#pragma hdrstop
#include <condefs.h>
#include <fstream>
#include <cerrno>
#include <cstring>
#include "crc32.h"

USEUNIT("crc32.cpp");
//---------------------------------------------------------------------------
using namespace std ;
using namespace Colosseum ;

int main(int argc, char **argv)
{
  if (argc != 2)
  {
    // Yes, it is possible for argc to be zero.
    const char *exename = "FILECRC" ;
    if (argc > 0)
      exename = argv [0] ;
    cerr << "Usage: " << exename << " inputfile " << endl ;
    return 1 ;
  }

  ifstream inputfile (argv [1], ios::binary) ;
  if (! inputfile)
  {
    cerr << "Can't open input file '" << argv [1] << endl <<
         ::strerror (errno) << endl ;
    return errno ;
  }


  Crc32 crc ;
  while (! inputfile.eof ())
  {
    static const int BUFFERSIZE = 512 ;
    char buffer [BUFFERSIZE] ;
    inputfile.read (buffer, BUFFERSIZE) ;
    int count = inputfile.gcount () ;
    if (count > 0)
    {
      crc.update (buffer, count) ;
    }
  }
  cout << "The CRC-32 value for '" << argv [1] << "' is "
       << hex << crc.value () << endl ;
  return 0;
}
