//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "ChartU.h"
#include "MainU.h"
//---------------------------------------------------------------------------
#if (__BORLANDC__ >= 0x530)
#pragma package(smart_init)
#endif
#pragma resource "*.dfm"
TChartForm *ChartForm;
//---------------------------------------------------------------------------
__fastcall
TChartForm::TChartForm(TComponent* Owner)
  : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall
TChartForm::CreateParams(TCreateParams& Params)
{
  // Call the base class CreateParams method.
  TForm::CreateParams(Params);
  // Set the style to create a child window.
  Params.Style = WS_CHILD | WS_CLIPSIBLINGS;
  // Set the window's parent as the main form.
  Params.WndParent = MainForm->Handle;
  // The X position of the window is 0.
  Params.X = 0;
  // If the main form is too narrow or too short
  // to accomodate the child form, resize it.
  if (Width > MainForm->ClientWidth)
    MainForm->ClientWidth = Width;
  if (Height > (MainForm->StatusBar->Top -
      MainForm->ToolBar->Height))
    MainForm->ClientHeight = Height +
      MainForm->ToolBar->Height +
      MainForm->StatusBar->Height;
  // The Y position of the child form is just
  // below the main form's toolbar.
  Params.Y = MainForm->ToolBar->Height + 1;
  // The width of the child form is the same as
  // the main form's client width.
  Params.Width = MainForm->ClientRect.Right;
  // Calculate a height based on the bottom of
  // the toolbar, and the top of the status bar.
  Params.Height =
    (MainForm->StatusBar->Top - 1) - Params.Y;
}

void __fastcall TChartForm::FormClose(
  TObject *Sender, TCloseAction &Action)
{
  // Update the main form's ActiveChild property
  // to indicate no child is active.
  MainForm->ActiveChild = 0;
  // The child form might have been closed via
  // the Close button so update the main menu's
  // check marks, and tell the VLC to clean up
  // the memory for this form.
  MainForm->Chart1->Checked = false;
  Action = caFree;
}
//---------------------------------------------------------------------------
void __fastcall
TChartForm::CloseBtnClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------
