#include <vcl.h>
#pragma hdrstop

#include "MainU.h"
#include "ChartU.h"
#include "TableU.h"

#if (__BORLANDC__ >= 0x530)
#pragma package(smart_init)
#endif
#pragma resource "*.dfm"
TMainForm *MainForm;

__fastcall
TMainForm::TMainForm(TComponent* Owner)
  : TForm(Owner)
{
  // Zero out the ActiveChild variable or it
  // will contain random data.
  ActiveChild = 0;
  // Open the main form's Table component.
  Table->Active = true;
}

void __fastcall
TMainForm::Table1Click(TObject *Sender)
{
  // If this form is already being displayed
  // then return without doing anything.
  if (Table1->Checked)
    return;
  // Delete the active child if it exists.
  if (ActiveChild) {
    delete ActiveChild;
    ActiveChild = 0;
  }
  // Create an instance of TTableForm.
  TTableForm* form = new TTableForm(this);
  // Assign the DBGrid::DataSource property of
  // the TTableForm's DBGrid to the datasource
  // on the main form.
  form->DBGrid->DataSource = DataSource;
  // Keep track of the active child.
  ActiveChild = form;
  // Show the form.
  form->Show();
  // Update the check marks on the View menu.
  Table1->Checked = true;
  Chart1->Checked = false;
}

void __fastcall
TMainForm::Chart1Click(TObject *Sender)
{
  // Essentially the same code as described
  // for the Table1Click method above.
  if (Chart1->Checked)
    return;
  if (ActiveChild)
    delete ActiveChild;
  TChartForm* form = new TChartForm(this);
  ActiveChild = form;
  form->Show();
  Chart1->Checked = true;
  Table1->Checked = false;
}

void __fastcall
TMainForm::FormResize(TObject *Sender)
{
  // If the main form is resized, resize the
  // active child to fill the client area of
  // the main form.
  if (ActiveChild) {
    ActiveChild->Width = ClientRect.Right;
    ActiveChild->Height =
      (MainForm->StatusBar->Top - 1) -
      ActiveChild->Top;
  }
}

