/****************************************************************************\

    FlatComboBox.cpp -- Created by Damon Chandler <dmc27@cornell.edu>

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************

\****************************************************************************/

#include <vcl.h>
#pragma hdrstop

#include "FlatComboBox.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//
// ValidCtrCheck is used to assure that the components
// created do not have any pure virtual functions.
//
static inline void ValidCtrCheck(TFlatComboBox *)
{
   new TFlatComboBox(NULL);
}

namespace Flatcombobox
{
   void __fastcall PACKAGE Register()
   {
       TComponentClass classes[1] = {__classid(TFlatComboBox)};
       RegisterComponents("Samples", classes, 0);
   }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------


__fastcall TFlatComboBox::TFlatComboBox(TComponent* Owner)
   : TComboBox(Owner), pushed_(false), mouse_in_control_(false)
{
}
//---------------------------------------------------------------------------

void __fastcall
  TFlatComboBox::WndProc(TMessage& AMsg)
{
  // only handle mouse- and action-
  // related messages at run-time
  if (!ComponentState.Contains(
    csDesigning))
  {
    switch (AMsg.Msg)
    {
      // when the left mouse
      // button is pressed
      case WM_LBUTTONDOWN:
      {
        pushed_ = true;
        break;
      }
      // when the left mouse
      // button is released
      case WM_LBUTTONUP:
      {
        pushed_ = false;
        if (!DroppedDown) Invalidate();
        break;
      }
      // when the mouse cursor
      // enters the combo box
      case CM_MOUSEENTER:
      {
        mouse_in_control_ = true;
        if (!DroppedDown) Invalidate();
        break;
      }
      // when the mouse cursor
      // leaves the combo box
      case CM_MOUSELEAVE:
      {
        mouse_in_control_ = false;
        if (!DroppedDown) Invalidate();
        break;
      }
      // on receipt of a reflected
      // WM_COMMAND message
      case CN_COMMAND:
      {
        // when the combo box's
        // drop-down list is closed
        if (AMsg.WParamHi == CBN_CLOSEUP)
        {
          pushed_ = false;
          Invalidate();
        }
        break;
      }
    }
  }
  // pass the messages on to the
  // default window procedure
  TComboBox::WndProc(AMsg);

  // after the combo box has drawn itself
  // and if it should be made flat...
  if (AMsg.Msg == WM_PAINT &&
      !mouse_in_control_)
  {
    // render the flat combo box
    std::auto_ptr<TControlCanvas>
      CBCanvas(new TControlCanvas());
    CBCanvas->Control = this;
    FlattenComboBox(*CBCanvas);
  }

  // when the Enabled property is changed
  else if (AMsg.Msg == CM_ENABLEDCHANGED)
  {
    Invalidate();
  }
}
//---------------------------------------------------------------------------

void __fastcall
  TFlatComboBox::FlattenComboBox(
    TCanvas& CBCanvas
    )
{
  RECT RBox =
    static_cast<RECT>(ClientRect);

  // use NULL_BRUSH so as not to
  // disturb edit control portion
  CBCanvas.Brush->Style = bsClear;

  // draw the new flat border
  CBCanvas.Pen->Width = 1;
  CBCanvas.Pen->Color = Color;
  CBCanvas.Rectangle(
    RBox.left, RBox.top,
    RBox.right, RBox.bottom
    );
  InflateRect(&RBox, -1, -1);
  CBCanvas.Pen->Width = 1;
  CBCanvas.Pen->Color = clBtnShadow;
  CBCanvas.Rectangle(
    RBox.left, RBox.top,
    RBox.right, RBox.bottom
    );

  // get the width of the scroll button
  int button_width =
     GetSystemMetrics(SM_CXVSCROLL);
  RECT RButton = {
    RBox.right - button_width - 1,
    RBox.top, RBox.right, RBox.bottom
    };

  // determine the style in
  // which to draw the button
  UINT style = DFCS_SCROLLCOMBOBOX;
  if (!Enabled) style |= DFCS_INACTIVE;
  if (pushed_) style |= DFCS_PUSHED;
  else style |= DFCS_FLAT;

  // draw the new scroll button
  DrawFrameControl(
    CBCanvas.Handle, &RButton,
    DFC_SCROLL, style
    );
}
//---------------------------------------------------------------------------


