#include <vcl.h>
#pragma hdrstop

#include "PictureSelector.h"
#pragma resource "PictureSelector.res"
#pragma package(smart_init)

__fastcall TPictureSelector::TPictureSelector(
  TComponent* Owner) : TWinControl(Owner)
{
  Width = 240;
  Height = 205;
  FComboBox = new TComboBox(this);
  FComboBox->Left = 0;
  FComboBox->Top = 0;
  FComboBox->Width = 150;
  FComboBox->Style = csDropDownList;
  FComboBox->OnClick = ComboBoxClick;
  FComboBox->Parent = this;
  FImage = new TImage(this);
  FImage->Left = 0;
  FImage->Top = FComboBox->Height;
  FImage->Width = Width;
  FImage->Height = Height - FComboBox->Height;
  FImage->Parent = this;
}

void __fastcall TPictureSelector::CreateWnd()
{
  TWinControl::CreateWnd();
  for (int i=0;i<6;i++)
    FComboBox->Items->Add(Strings[i]);
  FComboBox->ItemIndex = 0;
  ComboBoxClick(0);
}

void __fastcall TPictureSelector::ComboBoxClick(
  TObject* Sender)
{
  int index = 
    FComboBox->Items->IndexOf(FComboBox->Text);
  FImage->Picture->LoadFromFile(Strings[index]);
}

namespace Pictureselector
{
  void __fastcall PACKAGE Register()
  {
    TComponentClass classes[1] = 
      {__classid(TPictureSelector)};
    RegisterComponents("Samples", classes, 0);
  }
}

 