#include <vcl.h>
#pragma hdrstop

#include "Main.h"

#pragma package(smart_init)
#pragma resource "*.dfm"

TMainForm *MainForm;


__fastcall TMainForm::TMainForm(TComponent* Owner) : TForm(Owner)
   {
   Caption = Application->Title;

   Application->OnHint = OnHint;

   OnHint(0);
   }

void __fastcall TMainForm::OnHint(TObject *Sender)
   {
   if (Application->Hint.IsEmpty())
      {
      Shape1->Pen->Style = psClear;
      Shape2->Pen->Style = psClear;
      Shape3->Pen->Style = psClear;
      Shape4->Pen->Style = psClear;
      Shape5->Pen->Style = psClear;
      Shape6->Pen->Style = psClear;
      Shape7->Pen->Style = psClear;
      Panel2->Color = clBtnFace;
      Application->Hint = "Point to a button for a description.";
      }
   else if (Application->Hint == "ToolButton1")
      {
      Panel2->Color = clBtnText;
      Application->Hint = "ToolButton1, ToolButton2 and ToolButton3 are instances of TToolButton. "
                          "TToolButtons are contained only in a TToolBar.";
      }
   else if (Application->Hint == "Button1")
      {
      Shape7->Pen->Style = psSolid;
      Application->Hint = "Button1, Button2 and Button3 are instances of TButton. "
                          "TButton is a VCL encapsulation of the standard Windows button.";
      }
   else if (Application->Hint == "BitBtn1")
      {
      Shape4->Pen->Style = psClear;
      Shape5->Pen->Style = psClear;
      Shape6->Pen->Style = psSolid;
      Application->Hint = "BitBtn1, BitBtn2 and BitBtn3 are instances of TBitBtn. TBitBtn is derived "
                          "from TButton and adds properties that allow you to place glyphs on the "
                          "button. You can use glyphs provided with the VCL or you can use custom glyphs. "
                          "Or, as is the case with these three buttons, you can use text only and the "
                          "buttons will behave exactly like standard Windows buttons.";
      }
   else if (Application->Hint == "BitBtn4")
      {
      Shape4->Pen->Style = psClear;
      Shape5->Pen->Style = psSolid;
      Shape6->Pen->Style = psClear;
      Application->Hint = "These two instances of TBitBtn use the \"Kind\" property to use a glyph "
                          "and caption text provided by the VCL. There are eight more predefined sets of "
                          "glyphs and captions for TBitBtn in addition to the \"OK\" and \"Cancel\" Kinds used here.";
      }
   else if (Application->Hint == "BitBtn6")
      {
      Shape4->Pen->Style = psSolid;
      Shape5->Pen->Style = psClear;
      Shape6->Pen->Style = psClear;
      Application->Hint = "This instance of TBitBtn has three custom glyphs associated with it. "
                          "The glyphs are graphics of the words \"Up\", \"Disabled\" and \"Down\"."
                          "You can disable this button by unchecking the \"Enabled\" check box just below it.";
      }
   else if (Application->Hint == "SpeedButton1")
      {
      Shape1->Pen->Style = psClear;
      Shape2->Pen->Style = psClear;
      Shape3->Pen->Style = psSolid;
      Application->Hint = "SpeedButton1, SpeedButton2 and SpeedButton3 are all instances of TSpeedButton. "
                          "Because these buttons are derived from TGraphicControl instead of TWinControl "
                          "they use less Windows resources. Unfortunatley, this prevents the buttons from "
                          "getting keyboard focus. You can't tab to them and the only way to click one is with the mouse.";
      }
   else if (Application->Hint == "SpeedButton4")
      {
      Shape1->Pen->Style = psSolid;
      Shape2->Pen->Style = psClear;
      Shape3->Pen->Style = psClear;
      Application->Hint = "SpeedButton4, SpeedButton5 and SpeedButton6 are all instances of TSpeedButton. "
                          "These buttons have been set to behave like a group of three Windows radio buttons. "
                          "Only one of these three buttons may be down at a time.";
      }
   else if (Application->Hint == "SpeedButton7")
      {
      Shape1->Pen->Style = psClear;
      Shape2->Pen->Style = psSolid;
      Shape3->Pen->Style = psClear;
      Application->Hint = "This instance of TSpeedButton has four custom glyphs associated with it. "
                          "The glyphs are graphics of the words \"Up\", \"Disabled\", \"Down\" and \"Held Down\"."
                          "You can disable this button by unchecking the \"Enabled\" check box just below it. "
                          "You can make the button appear flat by checking the \"Flat\" check box below it."
                          "\r\n\r\nNotice that this TSpeedButton behaves like a standard check box.";
      }

   Label1->Caption = Application->Hint;
   }

void __fastcall TMainForm::CheckBox1Click(TObject *Sender)
   {
   BitBtn6->Enabled = CheckBox1->Checked;
   }

void __fastcall TMainForm::CheckBox2Click(TObject *Sender)
   {
   SpeedButton7->Enabled = CheckBox2->Checked;
   }

void __fastcall TMainForm::CheckBox3Click(TObject *Sender)
   {
   SpeedButton7->Flat = CheckBox3->Checked;
   }

void __fastcall TMainForm::ButtonClick(TObject *Sender)
   {
   if (CheckBox4->Checked == false) return;

   TButton *button = dynamic_cast<TButton *>(Sender);
   if (button == 0) return;

   ShowMessage(button->Caption + " was clicked.");
   }

void __fastcall TMainForm::BitBtnClick(TObject *Sender)
   {
   if (CheckBox4->Checked == false) return;

   TBitBtn *button = dynamic_cast<TBitBtn *>(Sender);
   if (button == 0) return;

   ShowMessage(button->Caption + " was clicked.");
   }

void __fastcall TMainForm::SpeedButtonClick(TObject *Sender)
   {
   if (CheckBox4->Checked == false) return;

   TSpeedButton *button = dynamic_cast<TSpeedButton *>(Sender);
   if (button == 0) return;

   ShowMessage(button->Caption + " was clicked.");
   }

