
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "OpenDialogEx.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------
// ValidCtrCheck is used to assure that the components created do not have
// any pure virtual functions.
//
static inline void ValidCtrCheck(TOpenDialogEx *)
{
  new TOpenDialogEx(NULL);
}
//---------------------------------------------------------------------------

namespace Opendialogex
{
  void __fastcall PACKAGE Register()
  {
    TComponentClass classes[1] = {__classid(TOpenDialogEx)};
    RegisterComponents("Samples", classes, 0);
  }
}
//---------------------------------------------------------------------------

__fastcall TOpenDialogEx::
  TOpenDialogEx(TComponent* Owner)
  : TOpenDialog(Owner), ChildWin_(NULL),
  OldDlgWP_(NULL), NewDlgWP_(NULL)
{
}
//---------------------------------------------------------------------------

void __fastcall TOpenDialogEx::
  SetChildWin(TWinControl* Value)
{
  if (ChildWin_ != Value)
  {
    ChildWin_ = Value;
    ChildWin_->Parent = NULL;
  }
}
//---------------------------------------------------------------------------

void __fastcall TOpenDialogEx::DoShow()
{
  if (
    ChildWin_ &&
    !Options.Contains(ofOldStyleDialog)
    )
  {
    RECT RDlg;
    const HWND hDlg = GetParent(Handle);
    if (GetWindowRect(hDlg, &RDlg))
    {
      // resize the dialog box
      SetWindowPos(
        hDlg, NULL, 0, 0,
        RDlg.right - RDlg.left +
        ChildWin_->Width + 6,
        RDlg.bottom - RDlg.top,
        SWP_NOMOVE | SWP_NOZORDER
        );

      // place and show the child window
      DoShowChildWin();

      // subclass the dialog
      DoSubclassDialog(true);
    }
  }
  TOpenDialog::DoShow();
}
//---------------------------------------------------------------------------

void __fastcall TOpenDialogEx::DoClose()
{
  if (ChildWin_)
  {
    // clean up
    ChildWin_->Hide();
    ChildWin_->ParentWindow = NULL;
  }
  TOpenDialog::DoClose();
}
//---------------------------------------------------------------------------

void __fastcall TOpenDialogEx::
  DoShowChildWin()
{
  RECT RDlg;
  const HWND hDlg = GetParent(Handle);
  if (GetClientRect(hDlg, &RDlg))
  {
    // parent the child to the dialog
    ChildWin_->ParentWindow = hDlg;

    // position/size the child window
    ChildWin_->Top = 3;
    ChildWin_->Left = RDlg.right -
      ChildWin_->Width - 6;
    ChildWin_->Height = RDlg.bottom - 10;

    // show the child window
    ChildWin_->Visible = true;

    // bring the child window to the top
    ChildWin_->BringToFront();
  }
}
//---------------------------------------------------------------------------

void __fastcall TOpenDialogEx::
  DoSubclassDialog(bool subclass)
{
  if (OldDlgWP_)
  {
    // restore the old window procedure
    SetWindowLong(
      GetParent(Handle), GWL_WNDPROC,
      reinterpret_cast<LONG>(OldDlgWP_)
      );
    OldDlgWP_ = NULL;
  }
  if (NewDlgWP_)
  {
    // free the function map
    FreeObjectInstance(NewDlgWP_);
    NewDlgWP_ = NULL;
  }

  if (!subclass) return;

  // allocate the function map
  NewDlgWP_ = reinterpret_cast<FARPROC>(
    MakeObjectInstance(DialogWndProc)
    );

  // perform the instance subclass
  const LONG res = SetWindowLong(
    GetParent(Handle), GWL_WNDPROC,
    reinterpret_cast<LONG>(NewDlgWP_)
    );
  OldDlgWP_ =
    reinterpret_cast<FARPROC>(res);
}
//---------------------------------------------------------------------------

void __fastcall TOpenDialogEx::
  DialogWndProc(TMessage& Msg)
{
  // call the default window procedure
  Msg.Result = CallWindowProc(
    OldDlgWP_, GetParent(Handle),
    Msg.Msg, Msg.WParam, Msg.LParam
    );

  switch (Msg.Msg)
  {
    case WM_SIZE:
    {
      RECT RDlg;
      const HWND hDlg =
        GetParent(Handle);
      if (::GetClientRect(hDlg, &RDlg))
      {
        // resize the child window
        ChildWin_->Height =
          RDlg.bottom - 10;
      }
      break;
    }
    case WM_DESTROY:
    {
      // remove the subclass
      DoSubclassDialog(false);
      break;
    }
  }
}
//---------------------------------------------------------------------------

