
//===========================================================================
#include <basepch.h>
#pragma hdrstop

#include "BasicDataObject.h"
#pragma package(smart_init)
//===========================================================================

// ValidCtrCheck is used to assure that the components created do not have
// any pure virtual functions.
//
static inline void
  ValidCtrCheck(TBasicDataObject*)
{
  new TBasicDataObject(NULL);
}
//---------------------------------------------------------------------------

namespace Basicdataobject
{
  void __fastcall PACKAGE Register()
  {
    TComponentClass classes[1] =
      {__classid(TBasicDataObject)};
    RegisterComponents(
      "Samples", classes, 0);
  }
}
//---------------------------------------------------------------------------
//===========================================================================



__fastcall TBasicDataObject::
  TBasicDataObject(TComponent* Owner) :
    TComponent(Owner), IDataObject(),
    ref_count_(1)
{
  OleInitialize(NULL);
}
//---------------------------------------------------------------------------

__fastcall TBasicDataObject::
  ~TBasicDataObject()
{
  OleUninitialize();
}
//---------------------------------------------------------------------------

HRESULT STDMETHODCALLTYPE
  TBasicDataObject::QueryGetData(
    FORMATETC* pFmtEtc)
{
  // verify the parameter
  if (pFmtEtc == NULL)
  {
    // indicate an invalid parameter
    return E_INVALIDARG;
  }

  // invoke the event handler...  
  if (OnQueryGetData_ != NULL)
  {
    return OnQueryGetData_(
      this, *pFmtEtc);
  }
  // else, indicate an unsupported format
  return DV_E_FORMATETC;
}
//---------------------------------------------------------------------------

HRESULT STDMETHODCALLTYPE
  TBasicDataObject::GetData(
    FORMATETC* pFmtEtc, STGMEDIUM* pStg)
{
  // verify the parameters
  if (pFmtEtc == NULL || pStg == NULL)
  {
    // indicate an invalid parameter
    return E_INVALIDARG;
  }

  // fire the event handler...
  if (OnGetData_ != NULL)
  {
    return OnGetData_(
      this, *pFmtEtc, *pStg);
  }
  // else, indicate an unsupported format
  return DV_E_FORMATETC;
}
//---------------------------------------------------------------------------
//===========================================================================

