
//===========================================================================
#ifndef BasicDataObjectH
#define BasicDataObjectH
//===========================================================================
#include <SysUtils.hpp>
#include <Classes.hpp>
#include <Controls.hpp>
#include <ComObj.hpp>
#include <Forms.hpp>
#include <ole2.h>
//---------------------------------------------------------------------------

class DELPHICLASS TBasicDataObject;
typedef HRESULT __fastcall
  (__closure *TOLEQueryGetDataEvent)(
    TBasicDataObject* Sender,
    FORMATETC& format
    );
typedef HRESULT __fastcall
  (__closure *TOLEGetDataEvent)(
    TBasicDataObject* Sender,
    FORMATETC& format,
    STGMEDIUM& storage    
    );

class PACKAGE TBasicDataObject :
  public TComponent, public IDataObject
{
__published:
  __property TOLEQueryGetDataEvent OnQueryGetData =
    {read=OnQueryGetData_, write=OnQueryGetData_};
  __property TOLEGetDataEvent OnGetData =
    {read=OnGetData_, write=OnGetData_};

public:
  __fastcall TBasicDataObject(TComponent* Owner);
  __fastcall ~TBasicDataObject();

  __property LONG RefCount =
    {read = ref_count_, write = ref_count_};

public: // inherited from TComponent
  virtual void __fastcall BeforeDestruction()
    {
      if (ref_count_ > 1)
      {
        throw Exception("Attempting to delete "
          "an object which contains an "
          "external reference.");
      }
    }

public: // inherited from IUnknown
  virtual ULONG STDMETHODCALLTYPE AddRef()
    {
      InterlockedIncrement(&ref_count_);
      return ref_count_;
    }
  virtual ULONG STDMETHODCALLTYPE Release()
    {
      if (InterlockedDecrement(&ref_count_) == 0)
      {
        delete this;
      }
      return ref_count_;
    }
#pragma warn -8022
  virtual HRESULT STDMETHODCALLTYPE
    QueryInterface(REFIID riid, void** ppvObj)
    {
      if (IsEqualIID(riid, IID_IUnknown) ||
          IsEqualIID(riid, IID_IDataObject))
      {
        *ppvObj = static_cast<IDataObject*>(this);
        AddRef();
        return NOERROR;
      }
      *ppvObj = NULL;
      return E_NOINTERFACE;
    }
#pragma warn .8022

protected: // inherited from IDataObject
  virtual HRESULT STDMETHODCALLTYPE QueryGetData(
    FORMATETC* pFmtEtc);
  virtual HRESULT STDMETHODCALLTYPE GetData(
    FORMATETC* pFmtEtc, STGMEDIUM* pStg);

  virtual HRESULT STDMETHODCALLTYPE EnumFormatEtc(
    DWORD dwDir, LPENUMFORMATETC* ppEnumFormatEtc)
    {
      return E_NOTIMPL;
    }
  virtual HRESULT STDMETHODCALLTYPE SetData(
    FORMATETC* pFmtEtc, STGMEDIUM* pStg,
    BOOL Release)
    {
      return E_NOTIMPL;
    }
  virtual HRESULT STDMETHODCALLTYPE GetDataHere(
    FORMATETC* pFmtEtc, STGMEDIUM* pStg)
    {
      return E_NOTIMPL;
    }
  virtual HRESULT STDMETHODCALLTYPE
    GetCanonicalFormatEtc(FORMATETC* pFmtEtcIn,
      FORMATETC* pFmtEtcOut)
    {
      return DATA_S_SAMEFORMATETC;
    }
  virtual HRESULT STDMETHODCALLTYPE DAdvise(
    FORMATETC* pFmtEtc, DWORD advf,
    LPADVISESINK pAdvSink, DWORD* pdwConnection)
    {
      return E_NOTIMPL;
    }
  virtual HRESULT STDMETHODCALLTYPE DUnadvise(
    DWORD dwConnection)
    {
      return E_NOTIMPL;
    }
  virtual HRESULT STDMETHODCALLTYPE EnumDAdvise(
    LPENUMSTATDATA* ppenumAdvise)
    {
      return OLE_E_ADVISENOTSUPPORTED;
    }

private:
  TOLEQueryGetDataEvent OnQueryGetData_;
  TOLEGetDataEvent OnGetData_;
  LONG ref_count_;
};
//---------------------------------------------------------------------------

//===========================================================================
#endif
//===========================================================================

