
//===========================================================================
#include <basepch.h>
#pragma hdrstop

#include "BasicDropSource.h"
#pragma package(smart_init)
//===========================================================================

// ValidCtrCheck is used to assure that the components created do not have
// any pure virtual functions.
//
static inline void
  ValidCtrCheck(TBasicDropSource*)
{
  new TBasicDropSource(NULL);
}
//---------------------------------------------------------------------------

namespace Basicdropsource
{
  void __fastcall PACKAGE Register()
  {
    TComponentClass classes[1] =
      {__classid(TBasicDropSource)};
    RegisterComponents(
      "Samples", classes, 0);
  }
}
//---------------------------------------------------------------------------
//===========================================================================



__fastcall TBasicDropSource::
  TBasicDropSource(TComponent* Owner) :
    TComponent(Owner), IDropSource(),
    ref_count_(1), OnFeedback_(NULL),
    OnQueryDrag_(NULL)
{
  OleInitialize(NULL);
}
//---------------------------------------------------------------------------

__fastcall TBasicDropSource::
  ~TBasicDropSource()
{
  OleUninitialize();
}
//---------------------------------------------------------------------------

HRESULT STDMETHODCALLTYPE
  TBasicDropSource::GiveFeedback(
    DWORD Effect)
{
  // invoke the event handler...
  if (OnFeedback_ != NULL)
  {
    OnFeedback_(this, Effect);
    return S_OK;
  }
  // else, use the default cursors
  return DRAGDROP_S_USEDEFAULTCURSORS;
}
//---------------------------------------------------------------------------

HRESULT STDMETHODCALLTYPE
  TBasicDropSource::QueryContinueDrag(
    BOOL EscPressed, DWORD Keys)
{
  // if the ESC key was pressed
  if (EscPressed)
  {
    // signal a cancelled drop
    return DRAGDROP_S_CANCEL;
  }

  // invoke the event handler...
  if (OnQueryDrag_ != NULL)
  {
    return OnQueryDrag_(
      this, KeysToShiftState(Keys));
  }
    
  // otherwise, if the user
  // has released the mouse
  if (!(Keys & MK_LBUTTON))
  {
    // signal a drop
    return DRAGDROP_S_DROP;
  }
  // continue the drag-and-drop cycle
  return S_OK;
}
//---------------------------------------------------------------------------
//===========================================================================




