
//===========================================================================
#ifndef BasicDropSourceH
#define BasicDropSourceH
//===========================================================================
#include <SysUtils.hpp>
#include <Classes.hpp>
#include <Controls.hpp>
#include <ComObj.hpp>
#include <Forms.hpp>
#include <ole2.h>
//---------------------------------------------------------------------------

class DELPHICLASS TBasicDropSource;
typedef void __fastcall
  (__closure *TOLEFeedbackEvent)(
    TBasicDropSource* Sender,
    DWORD& Effect
    );
typedef HRESULT __fastcall
  (__closure *TOLEQueryDragEvent)(
    TBasicDropSource* Sender,
    TShiftState Shift    
    );

class PACKAGE TBasicDropSource :
  public TComponent, public IDropSource
{
__published:
  __property TOLEFeedbackEvent OnFeedback =
    {read=OnFeedback_, write=OnFeedback_};
  __property TOLEQueryDragEvent OnQueryDrag =
    {read=OnQueryDrag_, write=OnQueryDrag_};

public:
  __fastcall TBasicDropSource(TComponent* Owner);
  __fastcall ~TBasicDropSource();
      
  __property LONG RefCount =
    {read = ref_count_, write = ref_count_};

public: // inherited from TComponent
  virtual void __fastcall BeforeDestruction()
    {
      if (ref_count_ > 1)
      {
        throw Exception("Attempting to delete "
          "an object which contains an "
          "external reference.");
      }
    }

public: // inherited from IUnknown
  virtual ULONG STDMETHODCALLTYPE AddRef()
    {
      InterlockedIncrement(&ref_count_);
      return ref_count_;
    }
  virtual ULONG STDMETHODCALLTYPE Release()
    {
      if (InterlockedDecrement(&ref_count_) == 0)
      {
        delete this;
      }
      return ref_count_;
    }
#pragma warn -8022
  virtual HRESULT STDMETHODCALLTYPE
    QueryInterface(REFIID riid, void** ppvObj)
    {
      if (IsEqualIID(riid, IID_IUnknown) ||
          IsEqualIID(riid, IID_IDropSource))
      {
        *ppvObj = static_cast<IDropSource*>(this);
        AddRef();
        return NOERROR;
      }
      *ppvObj = NULL;
      return E_NOINTERFACE;
    }
#pragma warn .8022    

protected: // inherited from IDropSource
  virtual HRESULT STDMETHODCALLTYPE GiveFeedback(
    DWORD dwEffect);
  virtual HRESULT STDMETHODCALLTYPE
    QueryContinueDrag(BOOL EscPressed, DWORD Keys);

private:
  TOLEFeedbackEvent OnFeedback_;
  TOLEQueryDragEvent OnQueryDrag_;
  LONG ref_count_;
};
//---------------------------------------------------------------------------

//===========================================================================
#endif
//===========================================================================
