
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit_DropSource.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "BasicDataObject"
#pragma link "BasicDropSource"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

HRESULT CanSupportText(FORMATETC& format)
{
  // we support only DVASPECT_CONTENT
  if (!(format.dwAspect &
    DVASPECT_CONTENT))
  {
    // invalid aspect
    return DV_E_DVASPECT;
  }
  // we support only TYMED_HGLOBAL
  if (!(format.tymed & TYMED_HGLOBAL))
  {
    // invalid medium type
    return DV_E_TYMED;
  }
  // we support only CF_HDROP
  if (format.cfFormat == CF_TEXT)
  {
    return S_OK;
  }
  // unsupported format
  return DV_E_FORMATETC;
}
//---------------------------------------------------------------------------



__fastcall TForm1::TForm1(TComponent* Owner)
   : TForm(Owner)
{
}
//---------------------------------------------------------------------------

HRESULT __fastcall TForm1::
  BasicDataObject1QueryGetData(
    TBasicDataObject* Sender,
    FORMATETC& format)
{
  // verify the format
  return CanSupportText(format);
}
//---------------------------------------------------------------------------

HRESULT __fastcall TForm1::
  BasicDataObject1GetData(
    TBasicDataObject *Sender,
    FORMATETC& format,
    STGMEDIUM& storage)
{
  // verify the format
  HRESULT const hRes =
    CanSupportText(format);
  if (hRes != S_OK)
  {
    return hRes;
  }

  // allocate memory for the text
  HGLOBAL const hMem = GlobalAlloc(
    GPTR, Label1->Caption.Length() + 1
    );
  if (hMem != NULL)
  {
    // copy the text
    lstrcpy(
      reinterpret_cast<LPSTR>(hMem),
      Label1->Caption.c_str()
      );

    // initialize the storage medium
    storage.hGlobal = hMem;
    storage.tymed = TYMED_HGLOBAL;
    storage.pUnkForRelease = NULL;

    return S_OK;
  }
  return E_OUTOFMEMORY;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Label1MouseDown(
  TObject* Sender, TMouseButton Button,
  TShiftState Shift, int X, int Y)
{
  // detect a mouse drag
  bool const do_drag = DragDetect(
    Label1->Parent->Handle,
    Mouse->CursorPos
    );
  if (!do_drag) return; // no drag
  //
  // else, start dragging...
  try
  {
    Label1->Font->Color = clBlue;
    BasicDropSource1->AddRef();

    DWORD user_effects;
    HRESULT const hRes = DoDragDrop(
      BasicDataObject1, BasicDropSource1,
      // specify the allowable effects
      DROPEFFECT_COPY | DROPEFFECT_MOVE,
      // will hold the selected effects
      &user_effects
      );

    if (SUCCEEDED(hRes) &&
        (user_effects & DROPEFFECT_MOVE))
    {
      // handle the "move" operation
      Label1->Caption = "";
    }
  }
  __finally
  {
    BasicDropSource1->Release();
    Label1->Font->Color = clWindowText;    
  }
}
//---------------------------------------------------------------------------

