#include <vcl.h>
#pragma hdrstop

#include "MainU.h"

#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;

TMyOpenDialog::TMyOpenDialog(TComponent* AOwner,
  char* TemplateName) : TOpenDialog(AOwner)
{
  // Pass on the dialog resource if one was
  // supplied. If not, set Template to nil
  // so the standard File Open dialog is shown.
  if (strlen(TemplateName) != 0)
    Template = TemplateName;
  else
    Template = NULL;
}

// The window procedure. We need to provide message
// handling for the extra controls on the form.
void __fastcall
TMyOpenDialog::WndProc(TMessage& Message)
{
  switch (Message.Msg) {
    case WM_INITDIALOG : {
      // Set the static label's text based on the
      // value of the Instructions property. The
      // resource ID for the static label is 102.
      SetWindowText(GetDlgItem
        (Handle, 102), FInstructions.c_str());
      break;
    }
    case WM_COMMAND : {
      // The check box was checked. Set the
      // Update property according to
      // the checkbox's checked state.
      if (LOWORD(Message.WParam) == 101 &&
         HIWORD(Message.WParam) == BN_CLICKED) {
        FUpdate =
          IsDlgButtonChecked(Handle, 101);
        Message.Result = 1;
      }
      break;
    }
  }
  TOpenDialog::WndProc(Message);
}

__fastcall TForm1::TForm1(TComponent* Owner)
  : TForm(Owner)
{
}

void __fastcall
TForm1::Button1Click(TObject *Sender)
{
  // Create an instance of the class using the
  // DIALOG1 dialog template. Assign text to
  // the Instructions property and Execute the
  // dialog.
  TMyOpenDialog* Dialog =
    new TMyOpenDialog(this, "DIALOG1");
  Dialog->Instructions = "Choose a file to "
    "open. If you wish to convert version "
    "1.0 files to the 2.0 format click the "
    "checkbox at the bottom of the dialog.";
  if (Dialog->Execute()) {
    Label1->Caption = Dialog->FileName;
    if (Dialog->Update) {
      Label2->Caption = "Checked";
      ShowMessage(
        "File updated to version 2.0 format.");
    }
    else
      Label2->Caption = "Not Checked";
  }
  delete Dialog;
}

void __fastcall
TForm1::Button2Click(TObject *Sender)
{
  // Create an instance of the class using the
  // DIALOG2 dialog template.
  TMyOpenDialog* Dialog =
    new TMyOpenDialog(this, "DIALOG2");
  Dialog->Instructions = "Choose a file to "
    "open. If you wish to convert version "
    "1.0 files to the 2.0 format click the "
    "checkbox at the bottom of the dialog.";
  if (Dialog->Execute()) {
    Label1->Caption = Dialog->FileName;
    if (Dialog->Update) {
      Label2->Caption = "Checked";
      ShowMessage(
        "File updated to version 2.0 format.");
    }
    else
      Label2->Caption = "Not Checked";
  }
  delete Dialog;
}

void __fastcall TForm1::Button3Click(TObject *Sender)
{
  OpenDialog1->Execute();
}

void __fastcall
TForm1::OpenDialog1Show(TObject *Sender)
{
  HWND hWndDlg =
    GetParent(OpenDialog1->Handle);
  HWND hWndBtn = GetDlgItem(hWndDlg, 1);
  SetWindowText(hWndBtn, "&Delete");

}

