#include <vcl.h>
#pragma hdrstop

#include "DLLVersion.h"
#include "Main.h"
#include "RecBin.h"

#if (__BORLANDC__ >= 0x530)
#pragma package(smart_init)
#endif
#pragma resource "*.dfm"

// Note to C++Builder 3 users. The Windows lib files that ship
// with BCB 3 does not include the recycle bin functions used in
// this example. You will need to create an import library file for
// SHELL32.DLL and add the lib file to the project. To create a lib
// file for SHELL32.DLL do the following:
//
// 1. Open a command prompt box.
// 2. Switch to the \Winnt\system32 (WinNT) or
//    \Windows\System (Win9x) directory.
// 3. At the command prompt ype IMPLIB SHELL32.LIB SHELL32.DLL
// 4. Copy or move the lib file to your project directory.
// 5. Add the lib file to the project using "Add to Project"

TMainForm *MainForm;


__fastcall TMainForm::TMainForm(TComponent* Owner) : TForm(Owner)
   {
   Caption = Application->Title;
   EmptyBtn->Enabled = CanEmptyRecycleBin();
   }

void __fastcall TMainForm::OKBtnClick(TObject *Sender)
   {
   Close();
   }

void __fastcall TMainForm::RecycleBtnClick(TObject *Sender)
   {
   MainMemo->Clear();
   MainMemo->Lines->Add("Delete Files to Recycle Bin");

   String path = ExtractFilePath(Application->ExeName);

   MainMemo->Lines->Add("Creating dummy files:");
   for (int i = 0; i < 3; i++)
      {
      String filename = path + "Dummy_" + String(i) + ".tmp";
      TFileStream *f = new TFileStream(filename, fmCreate);
      delete f;
      MainMemo->Lines->Add("\t" + filename);
      }

   MainMemo->Lines->Add("Deleting files to Recycle Bin");
   DeleteFiles(path + "Dummy??.tmp", true);

   MainMemo->Lines->Add("");
   EmptyBtn->Enabled = CanEmptyRecycleBin();
   }

void __fastcall TMainForm::EmptyBtnClick(TObject *Sender)
   {
   if (Application->MessageBox("Empty recycle bin?", Caption.c_str(), MB_YESNO) != IDYES) return;

   EmptyRecycleBin();

   MainMemo->Lines->Add("Recycle Bin Emptied");
   MainMemo->Lines->Add("");
   EmptyBtn->Enabled = false;

   }
//---------------------------------------------------------------------------

