//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "bcbrg.h"
#include "stdlib.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
TRadioButton* RadioButtonByCaption(TCustomRadioGroup* rg, String Caption)
{
  for (int i = 0; i < rg->ComponentCount - 1; i++) {
    TRadioButton* rb = dynamic_cast<TRadioButton*>(rg->Controls[i]);
    if (rb)
      if (rb->Caption == Caption) {
      return rb;
    }
  }
  return NULL;
}
//---------------------------------------------------------------------------
TRadioButton* RadioButtonByIndex(TCustomRadioGroup* rg, int Index)
{
  return (dynamic_cast<TRadioButton *>(rg->Controls[Index]));
}
//---------------------------------------------------------------------------
void FillListRandomly(TStrings* SrcList, TStrings* DestList)
{
  int i;
  randomize;

  if (!(SrcList->Count == 0)){
    do {
      i = random(SrcList->Count);
      DestList->Add(SrcList->Strings[i]);
      SrcList->Delete(i);
    } while (SrcList->Count > 0);
  }
}

//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  TRadioButton* rb;
  TStringList* tl = new TStringList();
  tl->LoadFromFile(ExtractFilePath(Application->ExeName) + "ITEMS.TXT");
  FillListRandomly(tl, RadioGroup1->Items);
  delete tl;

  for (int i = 0; i < RadioGroup1->ControlCount; i++) {
    rb = dynamic_cast<TRadioButton*>(RadioGroup1->Controls[i]);
    if (rb) {
      rb->ShowHint = true;
      rb->Hint = "Something about " + rb->Caption;
      rb->OnClick = RBOnClick;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RadioGroup1Click(TObject *Sender)
{
  // reset the color back to the normal one
  for (int i = 0; i < RadioGroup1->Items->Count; i++) {
    RadioButtonByIndex(RadioGroup1, i)->Font = RadioGroup1->Font;
  }

  RadioButtonByIndex(RadioGroup1, RadioGroup1->ItemIndex)->TabStop = RadioGroup1->TabStop;
  RadioButtonByIndex(RadioGroup1, RadioGroup1->ItemIndex)->Font->Color = clRed;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RBOnClick(TObject *Sender)
{
  TRadioButton* rb = dynamic_cast<TRadioButton*>(Sender);
  TRadioGroup* rg = dynamic_cast<TRadioGroup*>(rb->Parent);
  for (int i = 0; i < rb->Parent->ControlCount; i++) {
    TRadioButton* rb2 = dynamic_cast
      <TRadioButton*>(rg->Controls[i]);
    if (rb2)
      rb2->Font = rg->Font;
  }
  rb->Font->Color = clBlue;
  rb->Font->Style = rb->Font->Style << fsItalic;
  rb->TabStop = rb->Parent->TabStop;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  RadioButtonByIndex(RadioGroup1, 0)->Font->Name = "Arial";
  RadioButtonByIndex(RadioGroup1, 0)->Font->Size = 16;
  RadioButtonByIndex(RadioGroup1, 0)->Font->Color = clGreen;

  RadioButtonByCaption(RadioGroup1, "Item 3")->Font->Name = "Times New Roman";
  RadioButtonByCaption(RadioGroup1, "Item 3")->Font->Style << fsBold;
  RadioButtonByCaption(RadioGroup1, "Item 3")->Font->Color = clRed;
  RadioButtonByCaption(RadioGroup1, "Item 3")->Width = 100;
  RadioButtonByCaption(RadioGroup1, "Item 3")->Alignment = taLeftJustify;

  RadioButtonByIndex(RadioGroup1, RadioGroup1->Items->Count-1)->Enabled = false;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
{
  // reset the color back to the normal one
  for (int i = 0; i < RadioGroup1->Items->Count; i++) {
    RadioButtonByIndex(RadioGroup1, i)->Font = RadioGroup1->Font;
    RadioButtonByIndex(RadioGroup1, i)->Enabled = true;
    RadioButtonByIndex(RadioGroup1, i)->Alignment = taRightJustify;
  }
}
//---------------------------------------------------------------------------