#include <vcl.h>
#pragma hdrstop

#include <shellapi.h>
#include <shlobj.h>
#include "MainU.h"
#include "ViewImagesU.h"
#if (__BORLANDC__ >= 0x530)
#pragma package(smart_init)
#endif
#pragma resource "*.dfm"

TForm1 *Form1;
HINSTANCE Shell32Inst;
typedef LPITEMIDLIST (__stdcall *pILCombine)
  (LPITEMIDLIST, LPITEMIDLIST);
pILCombine ILCombine;
LPSHELLFOLDER DesktopFolder;

#if (__BORLANDC__ >= 0x530)
int __stdcall ListViewCompareFunc(long lParam1,
  long lParam2, long lParam)
#else
int __stdcall ListViewCompareFunc(int lParam1,
  int lParam2, int lParam)
#endif
{
  TListItem* Item1 = (TListItem*)lParam1;
  TListItem* Item2 = (TListItem*)lParam2;
  // Use CompareIDs to sort the list view.
  return (short)DesktopFolder->CompareIDs(0,
    (LPITEMIDLIST)Item1->Data,
    (LPITEMIDLIST)Item2->Data);
}

__fastcall TForm1::TForm1(TComponent* Owner)
  : TForm(Owner)
{
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  // Set up the image lists.
  ListView1->SmallImages = new TImageList(this);
  ListView1->LargeImages = new TImageList(this);
  ListView1->SmallImages->ShareImages = true;
  ListView1->LargeImages->ShareImages = true;
  SHFILEINFO fi;
  ListView1->SmallImages->Handle =
    SHGetFileInfo("", 0, &fi, sizeof(fi),
      SHGFI_SYSICONINDEX | SHGFI_SMALLICON);
  ListView1->LargeImages->Handle =
    SHGetFileInfo("", 0, &fi, sizeof(fi),
      SHGFI_SYSICONINDEX | SHGFI_LARGEICON);
  // Have to do some tricks to get the overlay
  // icons on Windows NT with the IE desktop
  // update installed.
  SHGetDesktopFolder(&DesktopFolder);
  DosExeIndex = -1;
  // IShellIconOverlay is only available in BCB 4.
  #if (__BORLANDC__ > 0x530)
  if (Win32Platform == VER_PLATFORM_WIN32_NT) {
    LPMALLOC Malloc;
    SHGetMalloc(&Malloc);
    LPSHELLFOLDER Folder;
    LPITEMIDLIST Pidl;
    LPITEMIDLIST ParentPidl;
    IShellIconOverlay *IconOverlay;
    DWORD Eaten;
    // Get the Windows temp directory.
    char tempDir[MAX_PATH - 1];
    GetTempPath(sizeof(tempDir), tempDir);
    // Build a path and filename to the
    // temporary file. Note that the file
    // has an extension of .lnk.
    char tempFile[MAX_PATH - 1];
    strcpy(tempFile, tempDir);
    strcat(tempFile, "temp.lnk");
    // Create the file.
    CreateFile(tempFile, GENERIC_WRITE, 0,
      0, CREATE_NEW, FILE_ATTRIBUTE_NORMAL, 0);
    // Get a pidl for the temp folder.
    wchar_t Path[MAX_PATH];
    StringToWideChar(tempDir, Path, MAX_PATH);
    DWORD Result = DesktopFolder->ParseDisplayName(
      Handle, 0, Path, &Eaten, &ParentPidl, 0);
    // Get an IShellFolder for the temp folder.
    Result = DesktopFolder->BindToObject(ParentPidl,
      0, IID_IShellFolder, (void**)&Folder);
    // Get an IShellIconOverlay interface
    // for the folder.
    Result = Folder->QueryInterface(
      IID_IShellIconOverlay, (void**)&IconOverlay);
    // If we failed then this version of the
    // shell does not have this interface. That's
    // OK, though, because in that case we
    // already have the overlay icons.
    if (Result == 0) {
      StringToWideChar("temp.lnk", Path, MAX_PATH);
      // Get a pidl for the temp file.
      Folder->ParseDisplayName(
        Handle, 0, Path, &Eaten, &Pidl, 0);
      int Index;
      // Get the overlay icons.
      IconOverlay->GetOverlayIndex(Pidl, &Index);
      IconOverlay->Release();
    }
    // Delete the temporary file.
    DeleteFile(tempFile);
    // Clean up.
    Malloc->Free(Pidl);
    Malloc->Free(ParentPidl);
    Folder->Release();
    Malloc->Release();
    // Obtain and save the icon index for NTDETECT.COM.
    // This index will be applied to DOS exes later on.
    SHFILEINFO fi;
    SHGetFileInfo("c:\\ntdetect.com", 0,
      &fi, sizeof(fi), SHGFI_SYSICONINDEX);
    DosExeIndex = fi.iIcon;
  }
  #endif
  // Load SHELL32.DLL and get a pointer to the
  // undocumented ILCombine function.
  Shell32Inst = LoadLibrary("shell32.dll");
  if (Shell32Inst)
    ILCombine = (pILCombine)GetProcAddress(
      Shell32Inst, (const char*)25);
}

void __fastcall TForm1::FormDestroy(TObject *Sender)
{
  FreeLibrary(Shell32Inst);
}

void __fastcall TForm1::EnumBtnClick(TObject *Sender)
{
  ListView1->Cursor = crHourGlass;
  ListView1->Perform(WM_SETREDRAW, 0, 0);
  FreePidls();
  ListView1->Items->Clear();

  LPSHELLFOLDER ParentFolder;
  LPITEMIDLIST ParentPidl;
  LPITEMIDLIST ChildPidl;
  LPITEMIDLIST fqPidl;
  DWORD Eaten;
  wchar_t Path[MAX_PATH];
  // Get an IShellFolder for the path in the edit.
  StringToWideChar(
    StartPathEdit->Text, Path, MAX_PATH);
  DWORD Result = DesktopFolder->ParseDisplayName(
    Handle, 0, Path, &Eaten, &ParentPidl, 0);
  Result = DesktopFolder->BindToObject(ParentPidl,
    0, IID_IShellFolder, (void**)&ParentFolder);
  if (Result != NOERROR)
    return;
  LPENUMIDLIST Enum;
  // Set enumeration flags to get all items.
  Result = ParentFolder->EnumObjects(Handle,
    SHCONTF_FOLDERS | SHCONTF_NONFOLDERS |
    SHCONTF_INCLUDEHIDDEN, &Enum);
  if (Result != NOERROR)
    return;
  // Get the pidl for the first item in the folder.
  LPMALLOC Malloc;
  SHGetMalloc(&Malloc);
  Result = Enum->Next(1, &ChildPidl, 0);
  while (Result != S_FALSE) {
    // If result is something other than
    // NOERROR then some error occured.
    if (Result != NOERROR)
      break;
    TListItem* Item = ListView1->Items->Add();
    fqPidl = ILCombine(ParentPidl, ChildPidl);
    SetItemAttributes(Item, fqPidl);
    // Free the memory for the pidl returned
    // by the Enum->Next() function.
    Malloc->Free(ChildPidl);
    // Get a pidl for the next item in the folder.
    Result = Enum->Next(1, &ChildPidl, 0);
  }
  // Sort the list view and enable drawing.
  ListView1->CustomSort(ListViewCompareFunc, 0);
  ListView1->Perform(WM_SETREDRAW, 1, 0);
  // Clean up.
  Malloc->Free(ParentPidl);
  Enum->Release();
  DesktopFolder->Release();
  ParentFolder->Release();
  Malloc->Release();
  ListView1->Cursor = crDefault;
}

void TForm1::SetItemAttributes(TListItem* item,
  LPITEMIDLIST pidl)
{
  DWORD Flags = SHGFI_PIDL |
    SHGFI_SYSICONINDEX | SHGFI_DISPLAYNAME |
    SHGFI_ATTRIBUTES;
  SHFILEINFO fi;
  DWORD Result = SHGetFileInfo(
    (char*)pidl, 0, &fi, sizeof(fi), Flags);
  // Error getting the info.
  if (Result == 0)
    return;
  // Set the image index with the value
  // returned by Windows. If the icon index
  // is 2 and the IE Desktop Update is installed,
  // then use the icon index of NTDETECT.COM.
  if (DosExeIndex != -1 && fi.iIcon == 2)
    item->ImageIndex = DosExeIndex;
  else
    item->ImageIndex = fi.iIcon;
  // Save the pidl in the Data property of the
  // item. We'll need it to sort the list view.
  item->Data = pidl;
  // Set the Cut property based on the
  // ghosted attribute.
  item->Cut = (fi.dwAttributes & SFGAO_GHOSTED)
       == SFGAO_GHOSTED;
  // Set the caption of the item.
  item->Caption = fi.szDisplayName;
  // Set the overlay icon index.
  if ((fi.dwAttributes & SFGAO_SHARE)
       == SFGAO_SHARE)
    item->OverlayIndex = 0;
  else if ((fi.dwAttributes & SFGAO_LINK)
       == SFGAO_LINK)
    item->OverlayIndex = 1;
  else
    item->OverlayIndex = -1;
}

void TForm1::FreePidls()
{
  LPMALLOC Malloc;
  SHGetMalloc(&Malloc);
  for (int i=0;i<ListView1->Items->Count;i++)
    Malloc->Free(ListView1->Items->Item[i]->Data);
  Malloc->Release();
}

void __fastcall TForm1::ShowIconsBtnClick(TObject *Sender)
{
  TViewImagesForm* form = new TViewImagesForm(this);
  form->SmallImages = ListView1->SmallImages;
  form->LargeImages = ListView1->LargeImages;
  form->ShowModal();
  delete form;
}

