#include <vcl.h>
#pragma hdrstop

#include "TransparentWindow.h"
#pragma package(smart_init)

static inline void
ValidCtrCheck(TTransparentWindow *)
{
  new TTransparentWindow(NULL);
}

__fastcall TTransparentWindow::TTransparentWindow(
  TComponent* Owner) : TComponent(Owner)
{
  //<AW>Make Sure Pointers Are NULL
  bmTransparentImage = NULL;
}

bool __fastcall
TTransparentWindow::Activate()
{
  bool bSuccess;

  /*<AW>If the image has been set and the
  Windows handle has been specified then
  we can continue and return success*/
  if (bmTransparentImage &&
  lWindowHandle!=0)
  {
    //<AW>Create an opaque region from a bitmap

    bSuccess=SetTransparentRegion
      (bmTransparentImage);
    if (bSuccess)
    //<AW>Set region for the supplied Windows handle
      SetWindowRgn (lWindowHandle, rgnOpaque, true);
  }
  else
  {
  //<AW>If something is missing then report
  // what and return failure
  if (bmTransparentImage==NULL)
    Application->MessageBox ("No Bitmap Selected",
      "Activate Cancelled", MB_OK);
  else if (lWindowHandle == 0)
    Application->MessageBox (
      "No Window Handle Selected",
      "Activate Cancelled", MB_OK);
  bSuccess=false;
  }
  return bSuccess;
}

void __fastcall
TTransparentWindow::SetTransparentImage(
  System::AnsiString value)
{
  //<AW>Set The Window Image
  try
  {
    //<AW>If The Bitmap Exists Then Delete It
    if (bmTransparentImage)
    {
      delete bmTransparentImage;
      bmTransparentImage = NULL;
    }
    //<AW>Load The Image
    bmTransparentImage = new Graphics::TBitmap();
    asTransparentImage = value;
    bmTransparentImage->
      LoadFromFile(asTransparentImage);
    bmTransparentImage->PixelFormat = pf8bit;
  }
  catch (Exception &e)
  {
    //<AW>Handle Any Errors And Delete The Pointer
    Application->MessageBox (e.Message.c_str(),
      "Couldn't Load Transparent Image", MB_OK);
    if (bmTransparentImage)
    {
      delete bmTransparentImage;
      bmTransparentImage = NULL;
      asTransparentImage = "";
    }
  }
}

__fastcall TTransparentWindow::~TTransparentWindow()
{
  //<AW>Clean Up And Delete The Bitmap
  if (bmTransparentImage)
    delete bmTransparentImage;
}

bool __fastcall
TTransparentWindow::SetTransparentRegion(
  Graphics::TBitmap *bmTransparentBitmap)
{
  //<AW>Set The Active Region Of The Window
  long X,Y,XTransparent;
  Byte *Line;
  HRGN rgnTransparent;
  bool bSuccess;
  try
  {
    bSuccess = true;
    //<AW>Loop Through Each ScanLine and Each Pixel
    rgnOpaque = CreateRectRgn (0, 0,
     bmTransparentBitmap->Width,
     bmTransparentBitmap->Height);
    for (Y=0;Y<bmTransparentBitmap->Height;Y++)
    {
      Line=(Byte*)bmTransparentBitmap->ScanLine[Y];
      for(X=0;X<bmTransparentBitmap->Width;X++)
      {
        while (X<bmTransparentBitmap->Width
          && Line[X]!=0)
        {
          //<AW>Process The Non-Transparent Region
          X++;
         }
        //<AW>Transparent Start
        XTransparent=X;

        while (X<bmTransparentBitmap->Width
          && Line[X]==0)
        {
          //<AW>Process The Transparent Region
          X++;
        }

        //<AW>If There Was A Transparent Region
        if (XTransparent<X)
        {
          //<AW>Create The Region
          //(Remove The Transparent Bit)
          rgnTransparent = CreateRectRgn
            (XTransparent, Y, X, Y+1);
          //<AW>If It's A Null Region, Return False
          if (CombineRgn (rgnOpaque,
            rgnOpaque, rgnTransparent,
            RGN_XOR) == NULLREGION)
          bSuccess=false;
         DeleteObject(rgnTransparent);
        }
      }
    }
  }
  catch (Exception &e)
  {
    //<AW>Catch The Errors
    Application->MessageBox(e.Message.c_str(),
      "Error Creating Transparency", MB_OK);
  }
  return bSuccess;
}

namespace Transparentwindow
{
  void __fastcall PACKAGE Register()
  {
    TComponentClass classes[1] =
      {__classid(TTransparentWindow)};
    RegisterComponents("Samples", classes, 0);
  }
}


