#include <vcl.h>
#pragma hdrstop

#include <mmsystem.h>

#include "Main.h"

#pragma package(smart_init)
#pragma resource "*.dfm"

TMainForm *MainForm;


__fastcall TMainForm::TMainForm(TComponent* Owner) : TForm(Owner)
   {
   Caption = Application->Title;

   DWORD ld = GetLogicalDrives();
   for (int i = 0; i < 26; i++)
      {
      if ((ld & (1 << i)) != 0)
         {
         String drv = String(char('A' + i)) + ":";
         if (GetDriveType(drv.c_str()) == DRIVE_CDROM) DriveCombo->Items->Add(drv);
         }
      }

   if (DriveCombo->Items->Count == 0)
      {
      OpenBtn->Enabled = false;
      CloseBtn->Enabled = false;
      DriveCombo->Items->Add("No CD-ROM Drives");
      }
   else
      DriveCombo->ItemIndex = 0;
   }

void TMainForm::DoDoor(bool open)
   {
   OpenBtn->Enabled = false;
   CloseBtn->Enabled = false;
   StatusText->Caption = open ? "Opening..." : "Closing...";
   StatusText->Update();

   String s = "open " + DriveCombo->Items->Strings[DriveCombo->ItemIndex] + " type cdaudio alias cd";
   mciSendString(s.c_str(), 0, 0, 0);
   s = "set cd door " + String(open ? "open" : "closed");
   mciSendString(s.c_str(), 0, 0, 0);
   mciSendString("close cd", 0, 0, 0);

   StatusText->Caption = "";
   OpenBtn->Enabled = true;
   CloseBtn->Enabled = true;
   }

void __fastcall TMainForm::OpenBtnClick(TObject *Sender)
   {
   DoDoor(true);
   }

void __fastcall TMainForm::CloseBtnClick(TObject *Sender)
   {
   DoDoor(false);
   }

