#include <vcl.h>
#pragma hdrstop

#include "DelFiles.h"


TDeleteFiles::TDeleteFiles()
   {
   allowUndo = true;
   noConfirm = false;
   silent = false;
   userCancelled = false;
   }

void TDeleteFiles::Add(const String &file)
   {
   fileList += file + String('\0');
   }

void TDeleteFiles::Clear()
   {
   fileList = "";
   }

bool TDeleteFiles::Delete()
   {
   if (fileList.IsEmpty()) return(true);

   fileList += String('\0');

   SHFILEOPSTRUCT op;
   ZeroMemory(&op, sizeof(SHFILEOPSTRUCT));
   op.hwnd = Application->MainForm->Handle;
   op.wFunc = FO_DELETE;
   if (allowUndo) op.fFlags |= FOF_ALLOWUNDO;
   if (noConfirm) op.fFlags |= FOF_NOCONFIRMATION;
   if (silent) op.fFlags |= FOF_SILENT;
   op.pFrom = fileList.c_str();

   bool success = SHFileOperation(&op) == 0;

   userCancelled = op.fAnyOperationsAborted;

   Clear();

   return(success);
   }

#pragma package(smart_init)
