#include <vcl.h>
#pragma hdrstop

#include <memory>
using namespace std;

#include "Main.h"
#include "PathDlg.h"
#include "PatternDlg.h"

#pragma package(smart_init)
#pragma resource "*.dfm"

TMainForm *MainForm;

const unsigned long MATCH_LIMIT = 10000;


__fastcall TMainForm::TMainForm(TComponent* Owner) : TForm(Owner)
   {
   Caption = Application->Title;

   fileFinder.OnFileFound = OnFileFound;
   fileFinder.OnSearchFolder = OnSearchFolder;

   sortType = -1;
   sortAscending = true;

   if (FileExists("FF.set")) LoadSettings("FF.set");
   DisplaySettings();

   RecycleChk->Checked = deleteFiles.AllowUndo;
   ConfirmChk->Checked = !deleteFiles.NoConfirm;
   ProgressChk->Checked = !deleteFiles.Silent;
   PreviewOnlyChk->Checked = previewOnly;

   settingsChanged = false;
   }

void TMainForm::LoadSettings(String fileName)
   {
   fileFinder.Paths->Clear();
   fileFinder.SkipPaths->Clear();
   fileFinder.Include->Clear();
   fileFinder.Exclude->Clear();

   auto_ptr<TStringList>temp(new TStringList());
   temp->LoadFromFile(fileName);

   auto_ptr<TStringList>settings(new TStringList());

   enum setState {NONE, PATH, PATHS, SKIP, SKIPS, INCLUDE, EXCLUDE, SETTINGS};
   setState mode = NONE;

   for (int i = 0; i < temp->Count; i++)
      {
      String test = temp->Strings[i];
      test.Trim();

      if (test.IsEmpty()) continue;

      if (test.Length() > 1 && test[1] == '/' && test[2] == '/') continue;		// Comment

      if (test.AnsiCompareIC("[PATH]") == 0)
         {
         mode = PATH;
         continue;
         }

      if (test.AnsiCompareIC("[PATHS]") == 0)
         {
         mode = PATHS;
         continue;
         }

      if (test.AnsiCompareIC("[SKIP]") == 0)
         {
         mode = SKIP;
         continue;
         }

      if (test.AnsiCompareIC("[SKIPS]") == 0)
         {
         mode = SKIPS;
         continue;
         }

      if (test.AnsiCompareIC("[INCLUDE]") == 0)
         {
         mode = INCLUDE;
         continue;
         }

      if (test.AnsiCompareIC("[EXCLUDE]") == 0)
         {
         mode = EXCLUDE;
         continue;
         }

      if (test.AnsiCompareIC("[SETTINGS]") == 0)
         {
         mode = SETTINGS;
         continue;
         }

      switch (mode)
         {
         case PATH:
            fileFinder.Paths->Add(test, false);
            break;
         case PATHS:
            fileFinder.Paths->Add(test, true);
            break;
         case SKIP:
            fileFinder.SkipPaths->Add(test, true);
            break;
         case SKIPS:
            fileFinder.SkipPaths->Add(test, false);
            break;
         case INCLUDE:
            fileFinder.Include->Add(test);
            break;
         case EXCLUDE:
            fileFinder.Exclude->Add(test);
            break;
         case SETTINGS:
            settings->Add(test.LowerCase());
            break;
         default:
            continue;
           }
       }

   // Other settings
   deleteFiles.AllowUndo = settings->Values["recycle"] == "false" ? false : true;
   deleteFiles.NoConfirm = settings->Values["confirm"] == "false" ? true : false;
   deleteFiles.Silent = settings->Values["silent"] == "true" ? true : false;
   previewOnly = settings->Values["preview"] == "false" ? false : true;

   settingsChanged = false;
   }

void TMainForm::SaveSettings(String fileName)
   {
   auto_ptr<TStringList>temp(new TStringList());

   temp->Add("// " + Application->Title + " Settings\r\n");

   temp->Add("[Path]");
   for (int i = 0; i < fileFinder.Paths->Count; i++)
      if (fileFinder.Paths->SearchSubfolders[i] == false)
         temp->Add(fileFinder.Paths->Strings[i]);
   temp->Add("");

   temp->Add("[Paths]");
   for (int i = 0; i < fileFinder.Paths->Count; i++)
      if (fileFinder.Paths->SearchSubfolders[i] == true)
         temp->Add(fileFinder.Paths->Strings[i]);
   temp->Add("");

   temp->Add("[Skip]");
   for (int i = 0; i < fileFinder.SkipPaths->Count; i++)
      if (fileFinder.SkipPaths->SearchSubfolders[i] == true)
         temp->Add(fileFinder.SkipPaths->Strings[i]);
   temp->Add("");

   temp->Add("[Skips]");
   for (int i = 0; i < fileFinder.SkipPaths->Count; i++)
      if (fileFinder.SkipPaths->SearchSubfolders[i] == false)
         temp->Add(fileFinder.SkipPaths->Strings[i]);
   temp->Add("");

   temp->Add("[Include]");
   for (int i = 0; i < fileFinder.Include->Count; i++)
      temp->Add(fileFinder.Include->Strings[i]);
   temp->Add("");

   temp->Add("[Exclude]");
   for (int i = 0; i < fileFinder.Exclude->Count; i++)
      temp->Add(fileFinder.Exclude->Strings[i]);
   temp->Add("");

   temp->Add("[Settings]");
   temp->Add("recycle=" + String(deleteFiles.AllowUndo == true ? "true" : "false"));
   temp->Add("confirm=" + String(deleteFiles.NoConfirm == false ? "true" : "false"));
   temp->Add("silent=" + String(deleteFiles.Silent == true ? "true" : "false"));
   temp->Add("preview=" + String(previewOnly == true ? "true" : "false"));

   temp->SaveToFile(fileName);

   settingsChanged = false;
   }

void TMainForm::DisplaySettings()
   {
   SearchPathListView->Items->BeginUpdate();
   SearchPathListView->Items->Clear();
   SearchPathListView->Items->EndUpdate();

   for (int i = 0; i < fileFinder.Paths->Count; i++)
      {
      TListItem *item = SearchPathListView->Items->Add();
      item->Caption = fileFinder.Paths->Strings[i];
      item->SubItems->Add(fileFinder.Paths->SearchSubfolders[i] ? "Yes" : "No");
      }

   SkipPathListView->Items->BeginUpdate();
   SkipPathListView->Items->Clear();
   SkipPathListView->Items->EndUpdate();

   for (int i = 0; i < fileFinder.SkipPaths->Count; i++)
      {
      TListItem *item = SkipPathListView->Items->Add();
      item->Caption = fileFinder.SkipPaths->Strings[i];
      item->SubItems->Add(fileFinder.SkipPaths->SearchSubfolders[i] ? "Yes" : "No");
      }

   IncludeListView->Items->BeginUpdate();
   IncludeListView->Items->Clear();
   IncludeListView->Items->EndUpdate();

   for (int i = 0; i < fileFinder.Include->Count; i++)
      {
      TListItem *item = IncludeListView->Items->Add();
      item->Caption = fileFinder.Include->Strings[i];
      }

   ExcludeListView->Items->BeginUpdate();
   ExcludeListView->Items->Clear();
   ExcludeListView->Items->EndUpdate();

   for (int i = 0; i < fileFinder.Exclude->Count; i++)
      {
      TListItem *item = ExcludeListView->Items->Add();
      item->Caption = fileFinder.Exclude->Strings[i];
      }
   }

void __fastcall TMainForm::DeleteBtnClick(TObject *Sender)
   {
   count = 0;
   fsize = 0;

   DeleteBtn->Enabled = false;
   StopBtn->Enabled = true;

   FileListView->Items->BeginUpdate();
   FileListView->Items->Clear();
   FileListView->Items->EndUpdate();
   FileListView->SortType = stNone;
   StatusBar->Panels->Items[1]->Text = "";
   StatusBar->Panels->Items[2]->Text = "";

   deleteFiles.Clear();

   fileFinder.Find();

   if (previewOnly != true)
      {
      deleteFiles.AllowUndo = RecycleChk->Checked;
      deleteFiles.NoConfirm = !ConfirmChk->Checked;
      deleteFiles.Silent = !ProgressChk->Checked;

      deleteFiles.Delete();
      }

   StatusBar->Panels->Items[0]->Text = "";
   StopBtn->Enabled = false;
   DeleteBtn->Enabled = true;
   }

void __fastcall TMainForm::OnFileFound(TFileFinder *Sender, String fileName, String folderName,
TFFData data)
   {
   if (count == MATCH_LIMIT)
      {
      Sender->Stop();
      String msg = "There are more than " + FormatFloat("#,##0", MATCH_LIMIT) + " files that match.";
      Application->MessageBox(msg.c_str(), "Find Files", MB_OK | MB_ICONSTOP);
      return;
      }

   if (previewOnly != true)
      {
      deleteFiles.Add(folderName + fileName);
      }

   StatusBar->Panels->Items[1]->Text = "Files = " + FormatFloat("#,##0 ", ++count);
   fsize += data.GetSize();
   StatusBar->Panels->Items[2]->Text = "Total size = " +FormatFloat("#,##0 ", fsize);

   TListItem *item = FileListView->Items->Add();
   item->Caption = fileName;
   item->Indent = 1;

   item->SubItems->Add(data.IsFolder() ? String("Dir") : FormatFloat("#,##0", data.GetSize()));

   TDateTime dt;
   if (data.GetLastWriteDateTime(dt))
      item->SubItems->Add(FormatDateTime("mm/dd/yyyy hh:nn:ss ampm", dt));
   else
      item->SubItems->Add("unknown");

   item->SubItems->Add(folderName);

   item->Data = (void *)data.GetAttributes();
   }

void __fastcall TMainForm::OnSearchFolder(TFileFinder *Sender, String folderName, bool &skip)
   {
   if (skip == false) StatusBar->Panels->Items[0]->Text = folderName;
   }

void __fastcall TMainForm::StopBtnClick(TObject *Sender)
   {
   fileFinder.Stop();
   }

static String StripNumber(const String &number)
   {
   int c = number.Length();
   String temp;

   for (int i = 1; i <= c; i++)
      if (number[i] >= '0' && number[i] <= '9') temp += number[i];

   return(temp);
   }

void __fastcall TMainForm::FileListViewCompare(TObject *Sender,
      TListItem *Item1, TListItem *Item2, int Data, int &Compare)
   {
   int sortDir = sortAscending ? 1 : -1;

   switch (sortType)
      {
      case 0:
         Compare = CompareText(Item1->Caption, Item2->Caption);
         break;
      case 1:
         {
         int c = CompareText(Item1->SubItems->Strings[2], Item2->SubItems->Strings[2]);
         if (c == 0)
            c = CompareText(Item1->Caption, Item2->Caption);
         Compare = c;
         break;
         }
      case 2:
         {
         String sa = Item1->SubItems->Strings[0];
         String sb = Item2->SubItems->Strings[0];
         __int64 s1 = StrToInt64(StripNumber(sa));
         __int64 s2 = StrToInt64(StripNumber(sb));
         if (s1 < s2)
            Compare = -1;
         else if (s1 == s2)
            Compare = 0;
         else
            Compare = 1;
         break;
         }
      case 3:
      case 4:
      case 5:
         {
         String s1 = Item1->SubItems->Strings[1];
         String s2 = Item2->SubItems->Strings[1];
         if (CompareText(s1, s2) == 0)
            Compare = 0;
         else
            {
            if (CompareText(s1, "unknown") == 0)
               Compare = -1;
            else if (CompareText(s2, "unknown") == 0)
               Compare = 1;
            else
               {
               TDateTime d1 = StrToDateTime(s1);
               TDateTime d2 = StrToDateTime(s2);
               Compare = d1 < d2 ? -1 : 1;
               }
            }
         break;
         }
      }

   Compare *= sortDir;
   }

void __fastcall TMainForm::StatusBarResize(TObject *Sender)
   {
	int width = ClientWidth;
	for (int i = 1; i < StatusBar->Panels->Count; i++) width -= StatusBar->Panels->Items[i]->Width;

	StatusBar->Panels->Items[0]->Width = width;
   }

void __fastcall TMainForm::FormCloseQuery(TObject *Sender, bool &CanClose)
   {
   if (fileFinder.IsRunning() == false) return;

   if (Application->MessageBox("Stop search and exit?", "Find Files", MB_YESNO) == IDYES)
      fileFinder.Stop();
   else
      CanClose = false;
   }

void __fastcall TMainForm::FileListViewColumnClick(TObject *Sender, TListColumn *Column)
   {
   if (sortType == Column->Tag)
      sortAscending = !sortAscending;
   else
      {
      sortAscending = true;
      sortType = Column->Tag;
      }

   if (FileListView->SortType == stNone)
      FileListView->SortType = stData;
   else
      FileListView->AlphaSort();
   }



void __fastcall TMainForm::SaveBtnClick(TObject *Sender)
   {
   SaveSettings("FF.set");
   }

void TMainForm::AddPath(TFFPathList *list, TListView *view, bool searchSubfolders)
   {
   PathDialog->Caption = "Add Path";

   PathDialog->PathEdit->Text = "";
   PathDialog->SubFolderCheck->Checked = searchSubfolders;
   if (PathDialog->ShowModal() == mrOk)
      {
      list->Add(PathDialog->PathEdit->Text, PathDialog->SubFolderCheck->Checked);

      TListItem *item = view->Items->Add();
      item->Caption = PathDialog->PathEdit->Text;
      item->SubItems->Add(PathDialog->SubFolderCheck->Checked ? "Yes" : "No");

      settingsChanged = true;
      }
   }

void TMainForm::EditPath(TFFPathList *list, TListView *view)
   {
   PathDialog->Caption = "Edit Path";

   if (view->SelCount == 1)
      {
      TListItem *item = view->Selected;
      PathDialog->PathEdit->Text = item->Caption;
      PathDialog->SubFolderCheck->Checked = item->SubItems->Strings[0] == "Yes";

      if (PathDialog->ShowModal() == mrOk)
         {
         int index = list->IndexOf(item->Caption);
         list->Strings[index] = PathDialog->PathEdit->Text;
         list->SearchSubfolders[index] = PathDialog->SubFolderCheck->Checked;

         item->Caption = PathDialog->PathEdit->Text;
         item->SubItems->Strings[0] = PathDialog->SubFolderCheck->Checked ? "Yes" : "No";

         settingsChanged = true;
         }
      }
   else
      {
      TItemStates selected = TItemStates() << isSelected;
      TListItem *item = view->Selected;
      bool ss = item->SubItems->Strings[0] == "Yes";
      bool cs = ss;
      while (item != 0 && cs == ss)
         {
         ss = item->SubItems->Strings[0] == "Yes";
         item = view->GetNextItem(item, sdAll, selected);
         }

      PathDialog->PathEdit->Text = "";
      PathDialog->PathEdit->Color = clBtnFace;
      PathDialog->PathEdit->Enabled = false;
      PathDialog->SubFolderCheck->Checked = false;

      if (ss != cs)
         PathDialog->SubFolderCheck->State = cbGrayed;
      else
         PathDialog->SubFolderCheck->Checked = ss;

      if (PathDialog->ShowModal() == mrOk)
         {
         if (PathDialog->SubFolderCheck->State != cbGrayed)
            {
            TItemStates selected = TItemStates() << isSelected;
            TListItem *item = view->Selected;
            while (item)
               {
               int index = list->IndexOf(item->Caption);
               list->SearchSubfolders[index] = PathDialog->SubFolderCheck->Checked;
               item->SubItems->Strings[0] = PathDialog->SubFolderCheck->Checked ? "Yes" : "No";
               item = view->GetNextItem(item, sdAll, selected);
               }
            }

         settingsChanged = true;
         }

      PathDialog->PathEdit->Color = clWindow;
      PathDialog->PathEdit->Enabled = true;
      }
   }

void TMainForm::DeletePath(TFFPathList *list, TListView *view)
   {
   TItemStates selected = TItemStates() << isSelected;
   TListItem *item = view->Selected;
   while (item)
      {
      int index = list->IndexOf(item->Caption);
      if (index != -1) list->Delete(index);
      item = view->GetNextItem(item, sdAll, selected);
      }

   DisplaySettings();

   settingsChanged = true;
   }

void __fastcall TMainForm::PathAddBtnClick(TObject *Sender)
   {
   if (Sender == AddBtn1)
      AddPath(fileFinder.Paths, SearchPathListView, true);
   else if (Sender == AddBtn2)
      AddPath(fileFinder.SkipPaths, SkipPathListView, false);
   }

void __fastcall TMainForm::PathEditBtnClick(TObject *Sender)
   {
   if (Sender == EditBtn1)
      EditPath(fileFinder.Paths, SearchPathListView);
   else if (Sender == EditBtn2)
      EditPath(fileFinder.SkipPaths, SkipPathListView);
   }

void __fastcall TMainForm::PathDelBtnClick(TObject *Sender)
   {
   if (Sender == DelBtn1)
      DeletePath(fileFinder.Paths, SearchPathListView);
   else if (Sender == DelBtn2)
      DeletePath(fileFinder.SkipPaths, SkipPathListView);
   }

void __fastcall TMainForm::ApplicationEvents1Idle(TObject *Sender, bool &Done)
   {
   bool e1 = SearchPathListView->SelCount > 0;
   EditBtn1->Enabled = e1;
   DelBtn1->Enabled = e1;

   bool e2 = SkipPathListView->SelCount > 0;
   EditBtn2->Enabled = e2;
   DelBtn2->Enabled = e2;

   EditBtn3->Enabled = IncludeListView->SelCount == 1;
   DelBtn3->Enabled = IncludeListView->SelCount > 0;

   EditBtn4->Enabled = ExcludeListView->SelCount == 1;
   DelBtn4->Enabled = ExcludeListView->SelCount > 0;

   SaveBtn->Enabled = settingsChanged;

   previewOnly = PreviewOnlyChk->Checked;
   }

void TMainForm::AddPattern(TStringList *list, TListView *view)
   {
   PatternDialog->Caption = "Add Pattern";
   PatternDialog->PatternEdit->Text = "";
   if (PatternDialog->ShowModal() == mrOk)
      {
      list->Add(PatternDialog->PatternEdit->Text);
      TListItem *item = view->Items->Add();
      item->Caption = PatternDialog->PatternEdit->Text;

      settingsChanged = true;
      }
   }

void __fastcall TMainForm::PatternAddBtnClick(TObject *Sender)
   {
   if (Sender == AddBtn3)
      AddPattern(fileFinder.Include, IncludeListView);
   else if (Sender == AddBtn4)
      AddPattern(fileFinder.Exclude, ExcludeListView);
   }

void __fastcall TMainForm::EditPatternBtnClick(TObject *Sender)
   {
   if (Sender == EditBtn3)
      EditPattern(fileFinder.Include, IncludeListView);
   else if (Sender == EditBtn4)
      EditPattern(fileFinder.Exclude, ExcludeListView);
   }

void TMainForm::EditPattern(TStringList *list, TListView *view)
   {
   PatternDialog->Caption = "Edit Pattern";

   TListItem *item = view->Selected;
   PatternDialog->PatternEdit->Text = item->Caption;
   if (PatternDialog->ShowModal() == mrOk)
      {
      int index = list->IndexOf(item->Caption);
      list->Strings[index] = PatternDialog->PatternEdit->Text;
      item->Caption = PatternDialog->PatternEdit->Text;

      settingsChanged = true;
      }
   }

void __fastcall TMainForm::DelPatternBtnClick(TObject *Sender)
   {
   if (Sender == DelBtn3)
      DelPattern(fileFinder.Include, IncludeListView);
   else if (Sender == DelBtn4)
      DelPattern(fileFinder.Exclude, ExcludeListView);
   }

void TMainForm::DelPattern(TStringList *list, TListView *view)
   {
   TItemStates selected = TItemStates() << isSelected;
   TListItem *item = view->Selected;
   while (item)
      {
      int index = list->IndexOf(item->Caption);
      if (index != -1) list->Delete(index);
      item = view->GetNextItem(item, sdAll, selected);
      }

   DisplaySettings();

   settingsChanged = true;
   }

void __fastcall TMainForm::CheckBoxClick(TObject *Sender)
   {
   settingsChanged = true;
   }

