#ifndef MainH
#define MainH

#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <Grids.hpp>

#include "DelFiles.h"
#include "FileFinder.h"
#include <ActnList.hpp>
#include <AppEvnts.hpp>
#include <ExtCtrls.hpp>

class TMainForm : public TForm
   {
   __published:
      TStatusBar *StatusBar;
      TPageControl *PageControl1;
      TTabSheet *TabSheet1;
      TButton *DeleteBtn;
      TButton *StopBtn;
      TListView *FileListView;
      TTabSheet *TabSheet2;
      TLabel *Label2;
      TListView *SkipPathListView;
      TButton *AddBtn2;
      TButton *EditBtn2;
      TButton *DelBtn2;
      TListView *IncludeListView;
      TButton *AddBtn3;
      TButton *EditBtn3;
      TButton *DelBtn3;
      TLabel *Label3;
      TLabel *Label4;
      TListView *ExcludeListView;
      TButton *AddBtn4;
      TButton *EditBtn4;
      TButton *DelBtn4;
      TApplicationEvents *ApplicationEvents1;
      TLabel *Label1;
      TListView *SearchPathListView;
      TButton *AddBtn1;
      TButton *EditBtn1;
      TButton *DelBtn1;
      TPanel *Panel1;
      TButton *SaveBtn;
      TCheckBox *PreviewOnlyChk;
      TCheckBox *RecycleChk;
      TCheckBox *ConfirmChk;
      TCheckBox *ProgressChk;

      void __fastcall DeleteBtnClick(TObject *Sender);
      void __fastcall StopBtnClick(TObject *Sender);
      void __fastcall FileListViewCompare(TObject *Sender, TListItem *Item1,
          TListItem *Item2, int Data, int &Compare);
      void __fastcall StatusBarResize(TObject *Sender);
      void __fastcall FormCloseQuery(TObject *Sender, bool &CanClose);
      void __fastcall FileListViewColumnClick(TObject *Sender,
          TListColumn *Column);
      void __fastcall SaveBtnClick(TObject *Sender);
      void __fastcall PathAddBtnClick(TObject *Sender);
      void __fastcall PathEditBtnClick(TObject *Sender);
      void __fastcall PathDelBtnClick(TObject *Sender);
      void __fastcall ApplicationEvents1Idle(TObject *Sender, bool &Done);
      void __fastcall PatternAddBtnClick(TObject *Sender);
      void __fastcall EditPatternBtnClick(TObject *Sender);
      void __fastcall DelPatternBtnClick(TObject *Sender);
   void __fastcall CheckBoxClick(TObject *Sender);

   public:
      __fastcall TMainForm(TComponent* Owner);

   private:
      void LoadSettings(String fileName);
      void SaveSettings(String fileName);
      void DisplaySettings();

      void AddPath(TFFPathList *list, TListView *view, bool searchSubfolders);
      void EditPath(TFFPathList *list, TListView *view);
      void DeletePath(TFFPathList *list, TListView *view);
      void AddPattern(TStringList *list, TListView *view);
      void EditPattern(TStringList *list, TListView *view);
      void DelPattern(TStringList *list, TListView *view);

      void __fastcall OnFileFound(TFileFinder *Sender, String fileName, String folderName,
         TFFData data);
      void __fastcall OnSearchFolder(TFileFinder *Sender, String folderName, bool &skip);

      TFileFinder fileFinder;

      TDeleteFiles deleteFiles;

      unsigned long count;
      __int64 fsize;
      int sortType;
      bool sortAscending;
      bool settingsChanged;
      bool previewOnly;
   };


extern PACKAGE TMainForm *MainForm;


#endif   // MainH

