#include <vcl.h>
#pragma hdrstop

#include "MainU.h"

#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;

__fastcall TForm1::TForm1(TComponent* Owner)
  : TForm(Owner)
{
}

void __fastcall TForm1::AddDlgBtnClick(TObject *Sender)
{
  // Show the Map Network Drive dialog.
  WNetConnectionDialog(
    Handle, RESOURCETYPE_DISK);
  // Update the display.
  ShowConnections();
}

void __fastcall TForm1::RmvDlgBtnClick(TObject *Sender)
{
  // Show the Disconnect Network Drive dialog.
  WNetDisconnectDialog(
    Handle, RESOURCETYPE_DISK);
  ShowConnections();
}

void __fastcall TForm1::EnumBtnClick(TObject *Sender)
{
  ShowConnections();
}

void __fastcall TForm1::DrivesBtnClick(TObject *Sender)
{
  Memo1->Lines->Clear();
  char Buff[256];
  DWORD Size = sizeof(Buff);
  // Enumerate the drives starting with D:
  for (char i='D';i<'Z';i++) {
    String S = String(i) + ":";
    // Find out the drive type. if (it"s a
    // hardware drive) continue looking.
    int DriveType = GetDriveType(S.c_str());
    if ((DriveType == DRIVE_FIXED) ||
       (DriveType == DRIVE_CDROM) ||
       (DriveType == DRIVE_RAMDISK)) {
      Memo1->Lines->Add(S +
        "\tFixed, removable, or CD-ROM drive");
      continue;
    }
    // Must be a network drive. Get the
    // connection status.
    DWORD Res = WNetGetConnection(
      S.c_str(), Buff, &Size);
    // Check the status.
    String S2;
    if (Res == 0)
      // No error. Drive is already connected.
      S2 = "Connected to " + String(Buff);
    if (Res == ERROR_NOT_CONNECTED)
      // Drive not connected, so it"s available.
      S2 = "Available";
    if (Res == ERROR_CONNECTION_UNAVAIL)
      // Remembered but not connected, can't use
      S2 = "Remembered but not connected ("
        + String(Buff) + ")";
    // Show the connection in the memo.
    Memo1->Lines->Add(S + "\t" + S2);
  }
}

void __fastcall TForm1::MapBtnClick(TObject *Sender)
{
  TNetResource NR;
  // Zero the memory.
  ZeroMemory(&NR, sizeof(NR));
  // Mapping a disk.
  NR.dwType = RESOURCETYPE_DISK;
  // Set the drive letter and path based on
  // the contents of the corresponding edits.

  char Drive[3];
  char Path[256];
  strcpy(Drive, DriveEdit->Text.c_str());
  strcpy(Path, PathEdit->Text.c_str());
  NR.lpLocalName = Drive;
  NR.lpRemoteName = Path;
  // Make the connection, passing the username
  // and password in the corresponding edits.
  DWORD Res = WNetAddConnection2(&NR,
    PasswordEdit->Text.c_str(),
    UsernameEdit->Text.c_str(), 0);
  // Report the connection results.
  if (Res == 0)
    ShowMessage("Connected");
  else
    ShowMessage(
      "Unable to connect. Error code "
       + IntToStr(Res) + ".");
  // Update the display.
  ShowConnections();
}

void __fastcall TForm1::UnMapBtnClick(TObject *Sender)
{
  // Unmap the drive or connection. if (the
  // drive letter edit is empty) assume
  // the path edit contains the name of the
  // connection to terminate.
  char Buff[256];
  if (DriveEdit->Text != "")
    strcpy(Buff, DriveEdit->Text.c_str());
  else
    strcpy(Buff, PathEdit->Text.c_str());
  DWORD Res = WNetCancelConnection2(Buff, 0, False);
  // Show the results.
  if (Res == 0)
    ShowMessage("Drive " + String(Buff) + " disonnected.");
  else
    ShowMessage("Unable to disconnect. "
      " Error code " + String(Res) + ".");
  // Update the display.
  ShowConnections();
}

void TForm1::ShowConnections()
{
  TNetResource NR[30];
  Memo1->Lines->Clear();
  // First enumerate the active conncections.
  Memo1->Lines->Add("Active Connections:");
  HANDLE EnumHandle;
  DWORD Res = WNetOpenEnum(RESOURCE_CONNECTED,
    RESOURCETYPE_DISK, 0, 0, &EnumHandle);
  if ((Res != 0)) {
    ShowMessage("Error");
    return;
  }
  DWORD Count = 0xFFFFFFFF;
  DWORD Size = sizeof(TNetResource) * 30;
  Res = WNetEnumResource(
    EnumHandle, &Count, &NR, &Size);
  if ((Res != 0)) {
    if (Res == ERROR_NO_MORE_ITEMS)
      Memo1->Lines->Add("No active connections");
    else {
      ShowMessage("Error");
      return;
    }
  }
  // Iterate through the connections, and
  // display the connection name in the memo.
  String S;
  for (DWORD i=0;i<Count;i++) {
    if (NR[i].lpLocalName == "")
      S = "(none)";
    else
      S = NR[i].lpLocalName;
    Memo1->Lines->Add(
      S + "\t" + NR[i].lpRemoteName);
  }
  // Close the enumeration.
  WNetCloseEnum(EnumHandle);
  Memo1->Lines->Add("");

  // Now enumerate the remembered connections.
  Memo1->Lines->Add("Remembered Connections:");
  Res = WNetOpenEnum(RESOURCE_REMEMBERED,
    RESOURCETYPE_DISK, 0, 0, &EnumHandle);
  if ((Res != 0)) {
    ShowMessage("Error");
    return;
  }
  Count = 0xFFFFFFFF;
  Size = sizeof(TNetResource) * 30;
  Res = WNetEnumResource(
    EnumHandle, &Count, &NR, &Size);
  if ((Res != 0)) {
    if (Res == ERROR_NO_MORE_ITEMS)
      Memo1->Lines->Add(
        "\tNo remembered connections");
    else {
      ShowMessage("Error");
      return;
    }
  }

  if (Res == 0) {
    char Buff[512];
    Size = sizeof(Buff);
    for (DWORD i=0;i<Count;i++) {
      Res = WNetGetConnection(
        NR[i].lpLocalName, Buff, &Size);
      S = String(NR[i].lpLocalName) +
        "\t" + NR[i].lpRemoteName;
      if ((Res == ERROR_CONNECTION_UNAVAIL))
        S = S + "\t" + " (Not connected)";
      if (Res == 0)
        S = S + "\t" + " (Connected)";
      Memo1->Lines->Add(S);
    }
  }
  // Close the enumeration.
  WNetCloseEnum(EnumHandle);
}
