#include <vcl.h>
#pragma hdrstop

#include <shellapi.h>
#include <shlobj.h>
#include "MainU.h"

#if (__BORLANDC__ >= 0x530)
#pragma package(smart_init)
#endif
#pragma resource "*.dfm"
TForm1 *Form1;

__fastcall TForm1::TForm1(TComponent* Owner)
  : TForm(Owner)
{
  // Get the shell's IMalloc interface.
  SHGetMalloc(&Malloc);
}

__fastcall TForm1::~TForm1()
{
  // Release the IMalloc interface.
  Malloc->Release();
}

void TForm1::Enumerate(IShellFolder* ParentFolder,
  bool EnumNonFolders, int Levels)
{
  LPITEMIDLIST Pidl;
  LPENUMIDLIST Enum;
  // Set up the enumeration flags based on the
  // main form's enum options check boxes.
  DWORD EnumFlags = SHCONTF_FOLDERS;
  if (EnumNonFolders)
    EnumFlags |= SHCONTF_NONFOLDERS;
  DWORD Result = ParentFolder->EnumObjects(
        Handle, EnumFlags, &Enum);
  // Error - return.
  if (Result != NOERROR)
    return;
  String DisplayName;
  // Get the pidl for the first item in the folder.
  Result = Enum->Next(1, &Pidl, 0);

  SHGetMalloc(&Malloc);
  while (Result != S_FALSE) {
    int CurrentLevel = Levels;
    // If result is something other than
    // NOERROR then some error occured.
    if (Result != NOERROR)
      break;
    // Get the "normal" display name.
    DisplayName =
      GetDisplayName(Pidl, ParentFolder);
    // Add spaces to the string so each level
    // is indented.
    String PadStr = String().StringOfChar(
      ' ', (NumLevels - CurrentLevel) * 4);
    PadStr = PadStr + DisplayName;
    // Now get the full path using the
    // SHGDN_FORPARSING constant.
    DisplayName = GetDisplayName(
      Pidl, ParentFolder, SHGDN_FORPARSING);
    // Add it to the end of the string and
    // display the full string in the memo.
    Memo1->Lines->Add(
      PadStr + " (" + DisplayName + ")");
    CurrentLevel--;
    // See if this shell item is a folder.
    DWORD Attr = SFGAO_FOLDER;
    ParentFolder->GetAttributesOf(
      1, (LPCITEMIDLIST*)&Pidl, &Attr);
    if ((CurrentLevel > 0)
        && (Attr & SFGAO_FOLDER) == SFGAO_FOLDER) {
      LPSHELLFOLDER Folder;
      // Get the IShellFolder for the pidl.
      int res = ParentFolder->BindToObject(Pidl,
        0, IID_IShellFolder, (void**)&Folder);
      if (res == NOERROR) {
        // Recurse by calling Enumerate again.
        Enumerate(
          Folder, EnumNonFolders, CurrentLevel);
        // Free the memory for the new folder.
        Folder->Release();
      }
    }
    // Free the memory for the pidl returned
    // by the Enum->Next() function.
    Malloc->Free(Pidl);
    // If the user pressed the Stop button then
    // stop enumerating.
    Application->ProcessMessages();
    if (Abort)
      break;
    // Get a pidl for the next item in the folder.
    Result = Enum->Next(1, &Pidl, 0);
  }
  // Free the IEnumIDList interface.
  Enum->Release();
}

void __fastcall
TForm1::EnumBtnClick(TObject *Sender)
{
  StopBtn->Enabled = true;
  Abort = false;
  Memo1->Cursor = crHourGlass;
  Memo1->Lines->Clear();
  // Start with the desktop folder.
  LPSHELLFOLDER DesktopFolder;
  SHGetDesktopFolder(&DesktopFolder);
  // Set the number of levels.
  NumLevels = NumLevelsEdit->Text.ToIntDef(2);
  // Start enumerating. Enumerate is a recursive
  // function so we only call it once from here.
  Enumerate(DesktopFolder,
    EnumNonFoldersCb->Checked, NumLevels);
  // Free the IShellFolder for the desktop folder.
  DesktopFolder->Release();
  StopBtn->Enabled = false;
  Memo1->Cursor = crDefault;
}

String TForm1::GetDisplayName(LPITEMIDLIST Pidl,
  IShellFolder* ParentFolder, DWORD type)
{
  String DisplayName;
  STRRET StrRet;
  // Request the string as a char* although
  // Windows will likely ignore the request.
  StrRet.uType = STRRET_CSTR;
  // Call GetDisplayNameOf() to fill in the
  // STRRET structure.
  ParentFolder->GetDisplayNameOf(
    Pidl, type, &StrRet);
  // Extract the string based on the value
  // of the uType member of STRRET.
  switch (StrRet.uType) {
    case STRRET_CSTR :
      DisplayName = StrRet.cStr;
      break;
    case STRRET_WSTR :
      DisplayName =WideCharToString(StrRet.pOleStr);
      break;
    case STRRET_OFFSET :
      DisplayName = ((char*)Pidl) + StrRet.uOffset;
  }
  // Return the result.
  return DisplayName;
}

void __fastcall TForm1::StopBtnClick(TObject *Sender)
{
  // User clicked the Stop button so set the
  // Abort flag.
  Abort = true;
  StopBtn->Enabled = false;
  Memo1->Cursor = crDefault;
}

