/*
    This source code was written by Jeffrey J. Peters (c) 1999.
    It is hereby released into the public domain, for use by anyone
    for anything.

*/

//---------------------------------------------------------------------------
#ifndef PCRegExpH
#define PCRegExpH
//---------------------------------------------------------------------------
#include <SysUtils.hpp>
#include <Controls.hpp>
#include <Classes.hpp>
#include <Forms.hpp>

#include <pcre.h>
//---------------------------------------------------------------------------

#pragma option push -b-
enum _PCRE_Flags   // Regexp compile and execute flags for more info about
                   // these flags, see the Borland C++Builder Online help
                   // and search for "Internal option setting" or "Perl".
{
 pcfCASELESS       ,
 pcfMULTILINE      ,
 pcfDOTALL         ,
 pcfEXTENDED       ,
 pcfANCHORED       ,
 pcfDOLLAR_ENDONLY ,
 pcfEXTRA          ,
 pcfNOTBOL         ,
 pcfNOTEOL         ,
 pcfUNGREEDY       ,
};
#pragma option pop

typedef Set<_PCRE_Flags, pcfCASELESS, pcfUNGREEDY> TPCREFlags;

class __fastcall PACKAGE TPCRegExp : public TComponent
{
private:
   pcre*                   _CompiledPattern;
   int*                    _PIndexArray;
   int                     _IndexSize;

   AnsiString              FPatternString;
   AnsiString              FEntireMatch;

   TStringList*            FCaptureList;
   TPCREFlags              FCompileFlags;  // flags burned into the compile
   TPCREFlags              FExecuteFlags;  // flags set at execution time

protected:

   int MakeIntFromFlags(TPCREFlags &f);

public:
   TPCRegExp(TComponent* Owner);
   virtual ~TPCRegExp(void);
   bool Compile(AnsiString &ErrorString, int &ErrorOffset);
   bool Execute(const char *subject, int len = 0);
   void FillUpStringList(const char *subject, int num);
   AnsiString ConvertToString(const char *subject, int start, int end);


   __property TStringList*      CaptureList = {read=FCaptureList,write=FCaptureList};
   __property AnsiString        EntireMatch = {read=FEntireMatch,write=FEntireMatch};

__published:

   __property AnsiString        PatternString = {read=FPatternString,write=FPatternString};
   __property TPCREFlags        CompileFlags  = {read=FCompileFlags, write=FCompileFlags, default=0};
   __property TPCREFlags        ExecuteFlags  = {read=FExecuteFlags, write=FExecuteFlags, default=0};

};
//---------------------------------------------------------------------------
#endif
