#include <vcl.h>
#pragma hdrstop

#include "MainU.h"

#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;

int __fastcall
ListSortFunc(void* Item1, void* Item2)
{
  TFileItem* item1 = (TFileItem*)Item1;
  TFileItem* item2 = (TFileItem*)Item2;
  // Folder items come first so sort by folder.
  if (item1->IsFolder && !item2->IsFolder)
    return -1;
  if (item2->IsFolder && !item1->IsFolder)
    return 1;
  // Now sort by the display name of each item.
  return CompareText(
    item1->FileName, item2->FileName);
}

int __stdcall ListViewSortFunc(
  LPARAM Item1, LPARAM Item2, LPARAM Data)
{
  // This is the sort function for the list view
  // in normal mode. It is essentially the same
  // as the sort function for the TList.
  TListItem* item1 = (TListItem*)Item1;
  TListItem* item2 = (TListItem*)Item2;
  if (!item1->ImageIndex && item2->ImageIndex)
    return -1;
  if (item1->ImageIndex && !item2->ImageIndex)
    return 1;
  return
    CompareText(item1->Caption, item2->Caption);
}

__fastcall TForm1::TForm1(TComponent* Owner)
  : TForm(Owner)
{
  FileList = new TList;
  // Assign the form's TImageList to the
  // list view's LargeImages property.
  ListView1->LargeImages = LargeImages;
}

void __fastcall TForm1::FormDestroy(TObject *Sender)
{
  ClearList();
  delete FileList;
}

void __fastcall
TForm1::FillViewBtnClick(TObject *Sender)
{
  int startTime;
  if (VirtualRb->Checked) {
    //OwnerData must be true for virtual list views
    ListView1->OwnerData = true;
    startTime = GetTickCount();
    // Clear out the items and the TList.
    ListView1->Items->Clear();
    ClearList();
  }
  else {
    // Disable updates for the normal list view.
    ListView1->Perform(WM_SETREDRAW, 0, 0);
    ListView1->OwnerData = false;
    startTime = GetTickCount();
    ListView1->Items->Clear();
  }
  TSearchRec SR;
  FindFirst(
    PathEdit->Text + "\\*.*", faAnyFile, SR);
  while (FindNext(SR) == 0) {
    if (SR.Name == "..")
      continue;
    // Get the next file in the folder.
    String FileName = ExtractFileName(SR.Name);
    int IconIndex;
    // Set the IconIndex property based on type.
    if ((SR.Attr & faDirectory) != 0)
      IconIndex = 0;
    else if (ExtractFileExt(SR.Name) == ".exe")
      IconIndex = 2;
    else
      IconIndex = 1;
    if (VirtualRb->Checked) {
      // Create a new TFileItem, set its properties
      TFileItem* fi = new TFileItem;
      fi->FileName = FileName;
      fi->FullPath =
        PathEdit->Text + "\\" + SR.Name;
      fi->IconIndex = IconIndex;
      fi->IsFolder = (SR.Attr & faDirectory) != 0;
      // Add the item to the list.
      FileList->Add(fi);
    }
    else {
      // Normal list view stuff.
      TListItem* item = ListView1->Items->Add();
      item->Caption = FileName;
      item->ImageIndex = IconIndex;
    }
  }
  FindClose(SR);
  if (VirtualRb->Checked) {
    // Sort the list.
    FileList->Sort(ListSortFunc);
    // This is the part that causes the virtual
    // list view to begin updating.
    ListView1->Items->Count = FileList->Count;
  }
  else {
    // Sort the normal list view.
    ListView1->CustomSort(ListViewSortFunc, 0);
    // Enable updates again.
    ListView1->Perform(WM_SETREDRAW, 1, 0);
  }
  Label2->Caption = "Elapsed time: " +
    String(GetTickCount() - startTime) + "ms for "+
    String(ListView1->Items->Count) + " items";
}

void TForm1::ClearList()
{
  // Clear out the file list each time.
  for (int i=0;i<FileList->Count;i++)
    delete ((TFileItem*)FileList->Items[i]);
  FileList->Clear();
}

void __fastcall TForm1::ListView1Data(
  TObject *Sender, TListItem *Item)
{
  // Get a TFileItem pointer from the file list.
  TFileItem* fi =
    (TFileItem*)FileList->Items[Item->Index];
  // Set the Caption and ImageIndex properties.
  Item->Caption = fi->FileName;
  Item->ImageIndex = fi->IconIndex;
}

void __fastcall
TForm1::ListView1Click(TObject *Sender)
{
  // A list view item may have been selected. If
  // so, update a label on the form with the path
  // of the item that was selected.
  if (VirtualRb->Checked && ListView1->Selected) {
    TFileItem* fi = (TFileItem*)
      FileList->Items[ListView1->Selected->Index];
    Label3->Caption = fi->FullPath;
  }
}

void __fastcall
TForm1::SearchBtnClick(TObject *Sender)
{
  // Finds an item and, if found, selects it.
  TListItem* item = ListView1->FindCaption(
    0, SearchEdit->Text, false, true, false);
  ListView1->Selected = item;
  ListView1->SetFocus();
  // Windows macro to make sure the found item
  // is visible.
  ListView_EnsureVisible(
    ListView1->Handle, item->Index, false);
}

void __fastcall TForm1::ListView1DataFind(
  TObject *Sender, TItemFind Find,
  const AnsiString FindString,
  const TPoint &FindPosition, Pointer FindData,
  int StartIndex, TSearchDirection Direction,
  bool Wrap, int &Index)
{
  // This event handler is called when the
  // FindCaption method is called. Find the item.
  for (int i=0;i<FileList->Count;i++) {
    TFileItem* item =(TFileItem*)FileList->Items[i];
    if (UpperCase(item->FileName) ==
        UpperCase(FindString)) {
      Index = i;
      break;
    }
  }
}

