#ifndef FFPathListH
#define FFPathListH

#include <vcl.h>
#pragma hdrstop


class TFFPathList : public TStringList
   {
   public:
      virtual int __fastcall Add(const String path);
   	virtual int __fastcall Add(const String path, bool searchSubfolders);

      __property bool SearchSubfolders[int index] = {read = GetSearchSubfolders,
         write = SetSearchSubfolders};

   private:
      bool __fastcall GetSearchSubfolders(int index);
      void __fastcall SetSearchSubfolders(int index, bool search);

   	__property System::TObject* Objects[int Index] = {read=GetObject, write=PutObject};
   	virtual int __fastcall AddObject(const AnsiString S, System::TObject* AObject);
   };

inline int __fastcall TFFPathList::Add(const String path)
   {
   return(TStringList::Add(path));
   }

inline int __fastcall TFFPathList::Add(const String path, bool searchSubfolders)
   {
   return(AddObject(path, (TObject *)searchSubfolders));
   }

inline bool __fastcall TFFPathList::GetSearchSubfolders(int index)
   {
   return((bool)Objects[index]);
   }

inline void __fastcall TFFPathList::SetSearchSubfolders(int index, bool search)
   {
   Objects[index] = (TObject *)search;
   }

inline int __fastcall TFFPathList::AddObject(const AnsiString S, System::TObject* AObject)
   {
   return(TStringList::AddObject(S, AObject));
   }


#endif	// FFPathListH
