#ifndef FFStackH
#define FFStackH

#include <vcl.h>
#pragma hdrstop


class TFFStack
	{
   public:
   	TFFStack();
   	~TFFStack();

      void Push(AnsiString name);
      AnsiString Pop();

      void Empty();

      bool Contains(String name);
      bool IsEmpty();

   private:
      TStringList *list;
   };

inline TFFStack::TFFStack()
   {
   list = new TStringList;
   list->Sorted = true;
   list->Duplicates = dupIgnore;
   }

inline TFFStack::~TFFStack()
   {
   delete list;
   }

inline void TFFStack::Push(AnsiString name)
   {
   list->Add(name);
   }

inline AnsiString TFFStack::Pop()
   {
   AnsiString temp = list->Strings[0];
   list->Delete(0);
   return(temp);
   }

inline void TFFStack::Empty()
   {
   list->Clear();
   }

inline bool TFFStack::Contains(String name)
   {
   int index;
   return(list->Find(name, index));
   }

inline bool TFFStack::IsEmpty()
   {
   return(list->Count == 0);
   }


#endif   // FFStackH

