#include <vcl.h>
#pragma hdrstop

#include <Masks.hpp>

#include "FileFinder.h"
#include "FFStack.h"

TFileFinder::TFileFinder()
   {
   onFileFound = 0;
   onSearchFolder = 0;

   include = exclude = 0;
   paths = skipPaths = 0;

   try
      {
      include = new TStringList;
      exclude = new TStringList;
      paths = new TFFPathList;
      skipPaths = new TFFPathList;
      }
   catch(...)
      {
      delete include;
      delete exclude;
      delete paths;
      delete skipPaths;

      throw;
      }

   stop = true;
   matchFolders = false;
   }

TFileFinder::~TFileFinder()
   {
   delete include;
   delete exclude;
   delete paths;
   delete skipPaths;
   }

bool TFileFinder::SkipDir(const String dir)
   {
   bool skip = false;

   for (int i = 0; i < skipPaths->Count && skip == false; i++)
      {
      String test = IncludeTrailingBackslash(skipPaths->Strings[i]).UpperCase();
      String path = dir.UpperCase();
      skip = path == test || (path.Pos(test) == 1 && skipPaths->SearchSubfolders[i] == false);
      }

   if (onSearchFolder) onSearchFolder(this, dir, skip);

   return(skip);
   }

void TFileFinder::Find()
   {
   stop = false;

   TFFStack dirStack;

   for (int i = 0; i < paths->Count && stop == false; i++)
      {
      String curDir = IncludeTrailingBackslash(ExpandFileName(paths->Strings[i]));

      if (onFileFound && SkipDir(curDir) == false) FindFiles(curDir);

      if (paths->SearchSubfolders[i])
         {
         while (stop == false)
            {
            Application->ProcessMessages();

            FindDirs(curDir, dirStack);
            if (dirStack.IsEmpty()) break;

            curDir = dirStack.Pop();

            if (SkipDir(curDir)) continue;

            if (onFileFound) FindFiles(curDir);
            }
         }
      }

   stop = true;
   }

void TFileFinder::FindFiles(String dir)
   {
   TFFData ffData;

   String filePattern = dir + "*.*";

   HANDLE handle = FindFirstFile(filePattern.c_str(), &ffData.data);
   if (handle != INVALID_HANDLE_VALUE)
      {
      bool found = true;

      while (found == true && stop == false)
         {
         Application->ProcessMessages();

         if (ffData.IsFolder() == false || matchFolders == true)
            {
            String name = ffData.GetName();

            bool match = false;
            for (int i = 0; i < include->Count && match == false; i++)
               match = MatchesMask(name, include->Strings[i]);

            for (int i = 0; i < exclude->Count && match == true; i++)
               match = !MatchesMask(name, exclude->Strings[i]);

            if (match == true && name != "." && name != "..")
               onFileFound(this, name, dir, ffData);
            }

         found = (FindNextFile(handle, &ffData.data) != 0);
         }

      FindClose(handle);
      }
   }

void TFileFinder::FindDirs(String baseDir, TFFStack &stack)
   {
   TFFData ffData;

   String dirPattern = baseDir + "*.*";

   HANDLE handle = FindFirstFile(dirPattern.c_str(), &ffData.data);
   if (handle != INVALID_HANDLE_VALUE)
      {
      bool found = true;

      while (found == true && stop == false)
         {
         Application->ProcessMessages();

         if (ffData.IsFolder() && ffData.GetName() != "." && ffData.GetName() != "..")
            stack.Push(baseDir + ffData.GetName() + "\\");

         found = (FindNextFile(handle, &ffData.data) != 0);
         }

      FindClose(handle);
      }
   }

void __fastcall TFileFinder::SetInclude(TStringList *val)
   {
   include->Assign(val);
   }

void __fastcall TFileFinder::SetExclude(TStringList *val)
   {
   exclude->Assign(val);
   }

void __fastcall TFileFinder::SetPaths(TFFPathList *val)
   {
   paths->Assign(val);
   }

void __fastcall TFileFinder::SetSkipPaths(TFFPathList *val)
   {
   skipPaths->Assign(val);
   }


#pragma package(smart_init)

