#ifndef FileFinderH
#define FileFinderH

#include "FFData.h"
#include "FFPathList.h"

class TFFStack;
class TFileFinder;


typedef void __fastcall (__closure *TFileFound)(TFileFinder *Sender, String fileName,
   String foldername, TFFData data);
typedef void __fastcall (__closure *TSearchFolder)(TFileFinder *Sender, String folderName,
   bool &skip);


class TFileFinder
   {
   public:
      TFileFinder();
      ~TFileFinder();

      void Find();
      void Stop();
      bool IsRunning();

      __property TStringList *Include = {read = include, write = SetInclude};
      __property TStringList *Exclude = {read = exclude, write = SetExclude};
      __property TFFPathList *Paths = {read = paths, write = SetPaths};
      __property TFFPathList *SkipPaths = {read = skipPaths, write = SetSkipPaths};

      __property bool MatchFolders = {read = matchFolders, write = matchFolders};
      __property TFileFound OnFileFound = {read = onFileFound, write = onFileFound};
      __property TSearchFolder OnSearchFolder = {read = onSearchFolder, write = onSearchFolder};

   private:
      void FindFiles(String filePattern);
      void FindDirs(String baseDir, TFFStack &stack);
      bool SkipDir(const String dir);

      void __fastcall SetInclude(TStringList *val);
      void __fastcall SetExclude(TStringList *val);
      void __fastcall SetPaths(TFFPathList *val);
      void __fastcall SetSkipPaths(TFFPathList *val);

      TFileFound onFileFound;
      TSearchFolder onSearchFolder;

      TFFPathList *paths, *skipPaths;
      TStringList *include, *exclude;

      bool stop;
      bool matchFolders;
   };


// Inline Functions --------------------------------------------------------------------------------

inline void TFileFinder::Stop()
   {
   stop = true;
   }

inline bool TFileFinder::IsRunning()
   {
   return(stop == false);
   }


#endif   // FileFinderH

