template <class T> class ObjectList :
  public TStringList
{
  public:

  // Set OwnsObjects to true if the
  // objects should automatically be
  // deleted when the list is destroyed.
  bool OwnsObjects;

  __fastcall ObjectList(
    bool bOwnsObjects = false) :
      TStringList()
  {
    Duplicates = dupAccept;
    Sorted = true;
    OwnsObjects = bOwnsObjects;
  }

  __fastcall ~ObjectList()
  {
    ClearItems(OwnsObjects);
  }

  int AddItem(AnsiString sValue, T* ptr)
  {
    int index = Add(sValue);
    Objects[index] = (TObject*)ptr;
    return index;
  }

  int AddNewItem(
    AnsiString sValue, T* ptr)
  {
    T* newptr = new T;
    *newptr = *ptr;
    return AddItem(sValue, newptr);
  }

  T* GetItem(int index)
  {
    return (T*)Objects[index];
  }

  void SetItem(int index, T* ptr)
  {
    Objects[index] = (TObject*)ptr;
  }

  void ClearItems(bool Delete)
  {
    if (Delete) {
      for (int i=0;i<Count;i++) {
        T* ptr = GetItem(i);
        if (ptr) {
          delete ptr;
          SetItem(i, NULL);
        }
      }
    }
    Clear();
  }

  __property T*  Items[int Index] = {read=GetItem,write=SetItem};

};

 