//---------------------------------------------------------------------------
#ifndef TGrocListH
#define TGrocListH
//---------------------------------------------------------------------------
const int STORE_NAME_LENGTH = 25;
const int glBread = 1, glMilk = 2, glFruit = 4, glCereal = 8, glPBJ = 16;
class TGroceryList
{
  private:
    unsigned int FBitStash;
    char FStoreName[STORE_NAME_LENGTH + 1];
    bool GotMilk(){return (FBitStash & glMilk) > 0;}
    void GetMilk(bool NewValue)
        {NewValue ? FBitStash |= glMilk : FBitStash &= ~glMilk;}
    int GetNumOfLoaves()
    {
      unsigned int LoavesInt = (FBitStash << 2);
      return static_cast<int>(LoavesInt >> 29);
    }//End of GetNumOfLoaves().
    void SetNumOfLoaves(int NewValue)
    {
      if(NewValue >= 0 && NewValue <= 7)
      {
        FBitStash &= 0xC7FFFFFF;//Clear placeholders.
        FBitStash |= (NewValue << 27);//Set new value.
      }
      else
        ShowMessage("Get a life dude.");
    }//End of SetNumOfLoaves().
    String GetStoreName(){return ::AnsiString(FStoreName);}
    void SetStoreName(String NewName)
        {strncpy(FStoreName, NewName.c_str(), STORE_NAME_LENGTH);}
  public:
    TGroceryList(){memset(this, 0, sizeof(TGroceryList));}
    void Assign(TGroceryList * pGL)//Similar to ctor.  Fixed data structure.
    {
      if(pGL == NULL)
        ShowMessage("Hey dude, get a valid pointer would you?");
      else if(this == pGL)
        ShowMessage("Hey dude, get a life would you?");
      else
        memcpy(this, pGL, sizeof(TGroceryList));
    }//End of Assign().
    bool __property NeedMilk = {read=GotMilk, write=GetMilk};
    bool GotItems(int BitIndex){return (FBitStash & BitIndex) > 0;}
    void GetItems(int BitIndex, bool NewValue)
        {NewValue ? FBitStash |= BitIndex : FBitStash &= ~BitIndex;}
    bool NeedAnyGroceries()
      {return  GotItems(glBread | glMilk | glFruit | glCereal | glPBJ);}
    int __property NumOfLoaves = {read=GetNumOfLoaves, write=SetNumOfLoaves};
    String __property StoreName = {read=GetStoreName, write=SetStoreName};
};//End of TGroceryList.
//---------------------------------------------------------------------------
#endif
