
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "OpenDialogEx.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------
// ValidCtrCheck is used to assure that the components created do not have
// any pure virtual functions.
//
static inline void ValidCtrCheck(TOpenDialogEx *)
{
  new TOpenDialogEx(NULL);
}
//---------------------------------------------------------------------------

namespace Opendialogex
{
  void __fastcall PACKAGE Register()
  {
    TComponentClass classes[1] = {__classid(TOpenDialogEx)};
    RegisterComponents("Samples", classes, 0);
  }
}
//---------------------------------------------------------------------------

inline short Pix2DlgUnitsX(short x)
{
   return (x * 4.0) /
      LOWORD(GetDialogBaseUnits());
}

inline short Pix2DlgUnitsY(short y)
{
   return (y * 8.0) /
      HIWORD(GetDialogBaseUnits());
}

HGLOBAL CreateChildDlgTemplate(
   short dlg_w, short dlg_h,
   short stc_x, short stc_y,
   DWORD styles = 0,
   DWORD ex_styles = 0
  )
{
  // create a global memory object
  const HGLOBAL hTemplate =
    GlobalAlloc(GMEM_ZEROINIT, 384);

  // grab a pointer to the memory
  DLGTEMPLATE* pTemplate =
    static_cast<DLGTEMPLATE*>
      (GlobalLock(hTemplate));
  if (!pTemplate) return 0;

  // initialize the child dialog
  pTemplate->style =
    styles | WS_CHILD |
    WS_CLIPSIBLINGS | DS_CONTROL;
  pTemplate->dwExtendedStyle = ex_styles;    
  pTemplate->cdit = 1; // 1 child control
  pTemplate->cx = Pix2DlgUnitsX(dlg_w);
  pTemplate->cy = Pix2DlgUnitsY(dlg_h);

  //
  // grab a pointer to the data for
  // the dialog's menu, class, and
  // title properties
  //
  WORD* pData = reinterpret_cast<WORD*>
    (pTemplate + 1);
  //
  // set no menu, use default class,
  // and no title
  //
  pData += 3;

  //
  // grab a pointer to the data for
  // the "stc32" control properties
  //
  DLGITEMTEMPLATE* pItem =
    reinterpret_cast<DLGITEMTEMPLATE*>
      (pData);
  pItem->style = WS_CHILD | SS_LEFT;
  pItem->id = stc32;
  pItem->x = Pix2DlgUnitsX(stc_x);
  pItem->y = Pix2DlgUnitsY(stc_y);

  //
  // grab a ponter to the data for the
  // static's class and title properties
  //
  pData =
    reinterpret_cast<WORD*>(pItem + 1);
  // set the STATIC class and no title
  pData[0] = 0xFFFF;
  pData[1] = 0x0082;
  pData += 3;

  // clean up
  GlobalUnlock(hTemplate);

  // return a handle to the memory
  return hTemplate;
}
//---------------------------------------------------------------------------


__fastcall TOpenDialogEx::
  TOpenDialogEx(TComponent* Owner)
  : TOpenDialog(Owner),
    ChildWinLeft_(NULL),
    ChildWinTop_(NULL),
    ChildWinRight_(NULL),
    ChildWinBottom_(NULL),
    OldDlgWP_(NULL), NewDlgWP_(NULL)
{
}
//---------------------------------------------------------------------------

BOOL __fastcall TOpenDialogEx::
  TaskModalDialog(
    void* DialogFunc, void* DialogData
    )
{
  //
  // punt if there's a resource template
  // specified, or if there are no child
  // windows to add
  //
  if (Template || !HasChild())
  {
    // show the dialog
    return TOpenDialog::TaskModalDialog(
      DialogFunc, DialogData
      );
  }

  // create an in-memory template
  const HGLOBAL hTemplate =
    DoCreateTemplate();
  try
  {
    // grab a pointer to the OPENFILENAME
    TOpenFilename* pofn =
      static_cast<TOpenFilename*>
        (DialogData);
        
    // remove the resource template flag
    pofn->Flags &=
      ~OFN_ENABLETEMPLATE;
    // add the in-memory template flag
    pofn->Flags |=
      OFN_ENABLETEMPLATEHANDLE;
    // set the in-memory template handle
    pofn->hInstance = hTemplate;

    // show the dialog
    const BOOL ok =
      TOpenDialog::TaskModalDialog(
        DialogFunc, DialogData
        );
        
    // clean up
    GlobalFree(hTemplate);
    return ok;
  }
  catch (...)
  {
    // clean up  
    GlobalFree(hTemplate);
    throw;
  }
}
//---------------------------------------------------------------------------


void __fastcall TOpenDialogEx::DoShow()
{
  if (
    HasChild() &&
    !Options.Contains(ofOldStyleDialog)
    )
  {
    // show the child windows
    DoShowChildWins();

    // subclass the dialog
    DoSubclassDialog(true);
  }
  TOpenDialog::DoShow();
}
//---------------------------------------------------------------------------

void __fastcall TOpenDialogEx::DoClose()
{
   if (ChildWinLeft_)
   {
      // clean up
      ChildWinLeft_->Hide();
      ChildWinLeft_->ParentWindow = 0;
   }
   if (ChildWinTop_)
   {
      // clean up
      ChildWinTop_->Hide();
      ChildWinTop_->ParentWindow = 0;
   }
   if (ChildWinRight_)
   {
      // clean up
      ChildWinRight_->Hide();
      ChildWinRight_->ParentWindow = 0;
   }
   if (ChildWinBottom_)
   {
      // clean up
      ChildWinBottom_->Hide();
      ChildWinBottom_->ParentWindow = 0;
   }
   TOpenDialog::DoClose();
}
//---------------------------------------------------------------------------

void __fastcall TOpenDialogEx::
  DoShowChildWins()
{
  RECT RDlg;
  const HWND hChildDlg = Handle;
  if (GetClientRect(hChildDlg, &RDlg))
  {
    if (ChildWinLeft_)
    {
      // parent the child to the dialog
      ChildWinLeft_->
        ParentWindow = hChildDlg;

      // position/size the child window
      ChildWinLeft_->Left = 0;
      ChildWinLeft_->Top = 0;
      ChildWinLeft_->Height =
        RDlg.bottom;

      // show the child window
      ChildWinLeft_->Visible = true;
    }
    if (ChildWinTop_)
    {
      // parent the child to the dialog
      ChildWinTop_->
        ParentWindow = hChildDlg;

      // position/size the child window
      ChildWinTop_->Left =
        ChildWinLeft_ ?
        ChildWinLeft_->Width : 0;
      ChildWinTop_->Top = 0;
      ChildWinTop_->Width =
        RDlg.right -
        ChildWinTop_->Left -
        (ChildWinRight_ ?
         ChildWinRight_->Width : 0);

      // show the child window
      ChildWinTop_->Visible = true;
    }
    if (ChildWinRight_)
    {
      // parent the child to the dialog
      ChildWinRight_->
        ParentWindow = hChildDlg;

      // position/size the child window
      ChildWinRight_->Left =
        RDlg.right -
        ChildWinRight_->Width;
      ChildWinRight_->Top = 0;
      ChildWinRight_->Height =
        RDlg.bottom;

      // show the child window
      ChildWinRight_->Visible = true;
    }
    if (ChildWinBottom_)
    {
      // parent the child to the dialog
      ChildWinBottom_->
        ParentWindow = hChildDlg;

      // position/size the child window
      ChildWinBottom_->Left =
         ChildWinLeft_ ?
         ChildWinLeft_->Width : 0;
      ChildWinBottom_->Top =
        RDlg.bottom -
        ChildWinBottom_->Height;
      ChildWinBottom_->Width =
        RDlg.right -
        ChildWinBottom_->Left -
        (ChildWinRight_ ?
         ChildWinRight_->Width : 0);

      // show the child window
      ChildWinBottom_->Visible = true;
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TOpenDialogEx::
  DoSubclassDialog(bool subclass)
{
  if (OldDlgWP_)
  {
    // restore the old window procedure
    SetWindowLong(
      GetParent(Handle), GWL_WNDPROC,
      reinterpret_cast<LONG>(OldDlgWP_)
      );
    OldDlgWP_ = NULL;
  }
  if (NewDlgWP_)
  {
    // free the function map
    FreeObjectInstance(NewDlgWP_);
    NewDlgWP_ = NULL;
  }

  if (!subclass) return;

  // allocate the function map
  NewDlgWP_ = reinterpret_cast<FARPROC>(
    MakeObjectInstance(DialogWndProc)
    );

  // perform the instance subclass
  const LONG res = SetWindowLong(
    GetParent(Handle), GWL_WNDPROC,
    reinterpret_cast<LONG>(NewDlgWP_)
    );
  OldDlgWP_ =
    reinterpret_cast<FARPROC>(res);
}
//---------------------------------------------------------------------------

void __fastcall TOpenDialogEx::
  DialogWndProc(TMessage& Msg)
{
  // call the default window procedure
  const HWND hDlg = GetParent(Handle);  
  Msg.Result = CallWindowProc(
    OldDlgWP_, hDlg,
    Msg.Msg, Msg.WParam, Msg.LParam
    );

  switch (Msg.Msg)
  {
    case WM_SIZE:
    {
      RECT RDlg;
      if (::GetClientRect(hDlg, &RDlg))
      {
        // resize the child windows
        if (ChildWinLeft_)
        {
          ChildWinLeft_->Height =
            RDlg.bottom;
        }
        if (ChildWinRight_)
        {
          ChildWinRight_->Height =
            RDlg.bottom - 20;
        }
        if (ChildWinTop_)
        {
          ChildWinTop_->Width =
            RDlg.right -
            ChildWinTop_->Left -
            (ChildWinRight_ ?
             ChildWinRight_->Width : 0);
        }
        if (ChildWinBottom_)
        {
          ChildWinBottom_->Width =
            RDlg.right -
            ChildWinBottom_->Left -
            (ChildWinRight_ ?
             ChildWinRight_->Width : 0);
        }
      }
      break;
    }
    case WM_DESTROY:
    {
      // remove the subclass
      DoSubclassDialog(false);
      break;
    }
  }
}
//---------------------------------------------------------------------------

HGLOBAL __fastcall TOpenDialogEx::
  DoCreateTemplate()
{
  //
  // compute the desired location of the
  // "stc32" static control and the size
  // of the child dialog
  //
  const short stc_x = ChildWinLeft_ ?
    ChildWinLeft_->Width : 0;
  const short stc_y = ChildWinTop_ ?
    ChildWinTop_->Height : 0;
  const short dlg_w =
    stc_x + (ChildWinRight_ ?
    ChildWinRight_->Width : 0);
  const short dlg_h =
    stc_y + (ChildWinBottom_ ?
    ChildWinBottom_->Height : 0);

  // create the child dialog template
  return CreateChildDlgTemplate(
    dlg_w, dlg_h, stc_x, stc_y
    );
}
//---------------------------------------------------------------------------

