
//---------------------------------------------------------------------------
#ifndef OpenDialogExH
#define OpenDialogExH
//---------------------------------------------------------------------------
#include <SysUtils.hpp>
#include <Controls.hpp>
#include <Classes.hpp>
#include <Forms.hpp>
#include <Dialogs.hpp>

#include <dlgs.h>
//---------------------------------------------------------------------------

class PACKAGE TOpenDialogEx : public TOpenDialog
{
public:
  // default constructor
  __fastcall TOpenDialogEx(TComponent* Owner);

  // introduced property
  __property TWinControl* ChildWinLeft =
    {read = ChildWinLeft_,
     write = SetChildWinLeft};
  __property TWinControl* ChildWinTop =
    {read = ChildWinTop_,
     write = SetChildWinTop};
  __property TWinControl* ChildWinRight =
    {read = ChildWinRight_,
     write = SetChildWinRight};
  __property TWinControl* ChildWinBottom =
    {read = ChildWinBottom_,
     write = SetChildWinBottom};

protected:
  // inherited member functions
  DYNAMIC void __fastcall DoShow();
  DYNAMIC void __fastcall DoClose();
  virtual BOOL __fastcall TaskModalDialog
    (void* DialogFunc, void* DialogData);

  // introduced member functions
  virtual void __fastcall DoShowChildWins();
  virtual void __fastcall DoSubclassDialog
    (bool subclass);
  virtual void __fastcall DialogWndProc
    (TMessage& Msg);
  virtual HGLOBAL __fastcall DoCreateTemplate();

private:
  FARPROC OldDlgWP_;
  FARPROC NewDlgWP_;

  TWinControl* ChildWinLeft_;
  TWinControl* ChildWinTop_;
  TWinControl* ChildWinRight_;
  TWinControl* ChildWinBottom_;

  bool __fastcall HasChild()
    {
      return (
        ChildWinLeft_ || ChildWinTop_ ||
        ChildWinRight_ || ChildWinBottom_
        );
    }
  void __fastcall SetChildWinLeft
    (TWinControl* Value)
    {
      if (ChildWinLeft_ != Value)
      {
        ChildWinLeft_ = Value;
        ChildWinLeft_->Parent = NULL;
      }
    }
  void __fastcall SetChildWinTop
    (TWinControl* Value)
    {
      if (ChildWinTop_ != Value)
      {
        ChildWinTop_ = Value;
        ChildWinTop_->Parent = NULL;
      }
    }
  void __fastcall SetChildWinRight
    (TWinControl* Value)
    {
      if (ChildWinRight_ != Value)
      {
        ChildWinRight_ = Value;
        ChildWinRight_->Parent = NULL;
      }
    }
  void __fastcall SetChildWinBottom
    (TWinControl* Value)
    {
      if (ChildWinBottom_ != Value)
      {
        ChildWinBottom_ = Value;
        ChildWinBottom_->Parent = NULL;
      }
    }
};

//---------------------------------------------------------------------------
#endif
//---------------------------------------------------------------------------
