#include <vcl.h>
#pragma hdrstop

#include<Clipbrd.hpp>

#include "EditMod.h"

#pragma package(smart_init)
#pragma resource "*.dfm"

TEditModule *EditModule;


__fastcall TEditModule::TEditModule(TComponent* Owner) : TDataModule(Owner)
   {
   editor = 0;
   }

void __fastcall TEditModule::Copy(TObject *Sender)
   {
   Editor->CopyToClipboard();
   }

void __fastcall TEditModule::CopyActionUpdate(TObject *Sender)
   {
   CopyAction->Enabled = Editor->SelLength > 0;
   }

void __fastcall TEditModule::Cut(TObject *Sender)
   {
   Editor->CutToClipboard();
   }

void __fastcall TEditModule::CutActionUpdate(TObject *Sender)
   {
   CutAction->Enabled = Editor->SelLength > 0;
   }

void __fastcall TEditModule::Delete(TObject *Sender)
   {
   Editor->ClearSelection();
   }

void __fastcall TEditModule::DeleteActionUpdate(TObject *Sender)
   {
   DeleteAction->Enabled = Editor->SelLength > 0;
   }

void __fastcall TEditModule::Paste(TObject *Sender)
   {
   Editor->PasteFromClipboard();
   }

void __fastcall TEditModule::PasteActionUpdate(TObject *Sender)
   {
   PasteAction->Enabled = Clipboard()->HasFormat(CF_TEXT);
   }

void __fastcall TEditModule::SelectAll(TObject *Sender)
   {
   Editor->SelectAll();
   }

void __fastcall TEditModule::SelectAllActionUpdate(TObject *Sender)
   {
   SelectAllAction->Enabled = Editor->Lines->Text.IsEmpty() == false;
   }

void __fastcall TEditModule::Undo(TObject *Sender)
   {
   Editor->Undo();
   }

void __fastcall TEditModule::UndoActionUpdate(TObject *Sender)
   {
   UndoAction->Enabled = Editor->CanUndo;
   }

void __fastcall TEditModule::EditActionListUpdate(TBasicAction *Action, bool &Handled)
   {
   if (Editor == 0) Handled = true;
   }

void __fastcall TEditModule::EditActionListExecute(TBasicAction *Action, bool &Handled)
   {
   if (Editor == 0) throw Exception("There is no editor assigned to " + Name);
   }

