#ifndef EditModH
#define EditModH

#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ActnList.hpp>
#include <StdActns.hpp>
#include <Dialogs.hpp>
#include <ImgList.hpp>

class TEditModule : public TDataModule
   {
   __published:
      TActionList *EditActionList;
      TEditCut *CutAction;
      TEditCopy *CopyAction;
      TEditDelete *DeleteAction;
      TEditPaste *PasteAction;
      TEditSelectAll *SelectAllAction;
      TEditUndo *UndoAction;

      TImageList *EditImageList;

      void __fastcall Copy(TObject *Sender);
      void __fastcall CopyActionUpdate(TObject *Sender);
      void __fastcall Cut(TObject *Sender);
      void __fastcall CutActionUpdate(TObject *Sender);
      void __fastcall Delete(TObject *Sender);
      void __fastcall DeleteActionUpdate(TObject *Sender);
      void __fastcall Paste(TObject *Sender);
      void __fastcall PasteActionUpdate(TObject *Sender);
      void __fastcall SelectAll(TObject *Sender);
      void __fastcall SelectAllActionUpdate(TObject *Sender);
      void __fastcall Undo(TObject *Sender);
      void __fastcall UndoActionUpdate(TObject *Sender);
      void __fastcall EditActionListUpdate(TBasicAction *Action, bool &Handled);
      void __fastcall EditActionListExecute(TBasicAction *Action, bool &Handled);

   public:
      __fastcall TEditModule(TComponent* Owner);

      __property TRichEdit *Editor = {read = editor, write = editor};

   private:
      TRichEdit *editor;
   };


extern PACKAGE TEditModule *EditModule;


#endif   // EditModH
