#include <vcl.h>
#pragma hdrstop

#include "FileMod.h"

#pragma package(smart_init)
#pragma resource "*.dfm"

TFileModule *FileModule;


__fastcall TFileModule::TFileModule(TComponent* Owner) : TDataModule(Owner)
   {
   Editor = 0;
   onFileNameChange = 0;

   DefaultFileName = "Untitled.txt";

   ExitAction->Hint = ExitAction->Hint + Application->Title;
   }

void __fastcall TFileModule::Exit(TObject *Sender)
   {
   Application->MainForm->Close();
   }

void __fastcall TFileModule::New(TObject *Sender)
   {
   if (CloseQuery() == false) return;

   Editor->Clear();
   ClearModifiedFlag();

   FileName = defaultFileName;
   }

void __fastcall TFileModule::Open(TObject *Sender)
   {
   if (CloseQuery() == false) return;

   OpenDialog->FileName = "";
   if (OpenDialog->Execute() == false) return;

   FileName = OpenDialog->FileName;

   Editor->Lines->LoadFromFile(fileName);
   ClearModifiedFlag();
   }

void __fastcall TFileModule::Save(TObject *Sender)
   {
   Save(false);
   }

void __fastcall TFileModule::SaveAs(TObject *Sender)
   {
   Save(true);
   }

void __fastcall TFileModule::SaveActionUpdate(TObject *Sender)
   {
   SaveAction->Enabled = Editor->Modified;
   }

void __fastcall TFileModule::FileActionListExecute(TBasicAction *Action, bool &Handled)
   {
   if (Editor == 0) throw Exception("There is no editor assigned to " + Name);
   }

void __fastcall TFileModule::FileActionListUpdate(TBasicAction *Action, bool &Handled)
   {
   if (Editor == 0) Handled = true;
   }

bool TFileModule::CloseQuery()
   {
   if (Editor->Modified == false) return(true);

   String msg = "The text in " + FileName + " has changed."
      + "\r\n\r\nDo you want to save the changes?";
   int result = Application->MessageBox(msg.c_str(), Application->Title.c_str(),
      MB_YESNOCANCEL | MB_ICONWARNING);

   if (result == IDNO) return(true);

   if (result == IDCANCEL) return(false);

   return(Save(false));
   }

void __fastcall TFileModule::ChangeFileName(const String name)
   {
   fileName = name;

   if (onFileNameChange) onFileNameChange(this, fileName);
   }

void TFileModule::ClearModifiedFlag()
   {
   Editor->Modified = false;
   if (Editor->OnSelectionChange) Editor->OnSelectionChange(this);
   }

bool TFileModule::Save(bool useDialog)
   {
   if (useDialog || FileName == DefaultFileName)
      {
      SaveDialog->FileName = FileName;
      if (SaveDialog->Execute() == false) return(false);

      FileName = SaveDialog->FileName;
      }

   Editor->Lines->SaveToFile(FileName);
   ClearModifiedFlag();

   return(true);
   }

