#ifndef FileModH
#define FileModH

#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ActnList.hpp>
#include <ImgList.hpp>
#include <Dialogs.hpp>


typedef void __fastcall (__closure *TFileNameChange)(TObject *Sender, String fileName);


class TFileModule : public TDataModule
   {
   __published:
      TActionList *FileActionList;
      TImageList *FileImageList;
      TAction *NewAction;
      TAction *OpenAction;
      TAction *SaveAction;
      TAction *SaveAsAction;
      TAction *ExitAction;

      TOpenDialog *OpenDialog;
      TSaveDialog *SaveDialog;

      void __fastcall Exit(TObject *Sender);
      void __fastcall New(TObject *Sender);
      void __fastcall Open(TObject *Sender);
      void __fastcall Save(TObject *Sender);
      void __fastcall SaveAs(TObject *Sender);
      void __fastcall SaveActionUpdate(TObject *Sender);
      void __fastcall FileActionListExecute(TBasicAction *Action, bool &Handled);
      void __fastcall FileActionListUpdate(TBasicAction *Action, bool &Handled);

   public:
      __fastcall TFileModule(TComponent* Owner);

      bool CloseQuery();

      __property TRichEdit *Editor = {read = editor, write = editor};
      __property String FileName = {read = fileName, write = ChangeFileName};
      __property String DefaultFileName = {read = defaultFileName, write = defaultFileName};

      __property TFileNameChange OnFileNameChange = {read = onFileNameChange,
         write = onFileNameChange};

   private:
      void __fastcall ChangeFileName(String name);
      void ClearModifiedFlag();
      bool Save(bool useDialog);

      TRichEdit *editor;
      String fileName, defaultFileName;
      TFileNameChange onFileNameChange;
   };


extern PACKAGE TFileModule *FileModule;


#endif   // FileModH
