#include <vcl.h>
#pragma hdrstop

#include "Main.h"
#include "FileMod.h"
#include "FormatMod.h"
#include "EditMod.h"
#include "HelpMod.h"

#pragma package(smart_init)
#pragma resource "*.dfm"

const int PANEL_MODIFIED = 1;
const int PANEL_POSITION = 2;

TMainForm *MainForm;


__fastcall TMainForm::TMainForm(TComponent* Owner) : TForm(Owner)
   {
   Caption = Application->Title;

   FileModule->Editor = RichEdit;
   FileModule->OnFileNameChange = OnFileNameChange;
   FileModule->New(this);

   FormatModule->Editor = RichEdit;
   EditModule->Editor = RichEdit;
   }

void __fastcall TMainForm::OnFileNameChange(TObject *Sender, String fileName)
   {
   Caption = ExtractFileName(FileModule->FileName) + " - " + Application->Title;
   }

void __fastcall TMainForm::StatusBarResize(TObject *Sender)
   {
   int width = 0;

   for (int i = 1; i < StatusBar->Panels->Count; i++)
      width += StatusBar->Panels->Items[i]->Width;

   StatusBar->Panels->Items[0]->Width = StatusBar->ClientWidth - width;
   }

void __fastcall TMainForm::RichEditSelectionChange(TObject *Sender)
   {
   StatusBar->Panels->Items[PANEL_MODIFIED]->Text = RichEdit->Modified ? "Modified" : "";

   StatusBar->Panels->Items[PANEL_POSITION]->Text = String(RichEdit->CaretPos.y) + " : "
      + String(RichEdit->CaretPos.x);
   }

void __fastcall TMainForm::FormCloseQuery(TObject *Sender, bool &CanClose)
   {
   CanClose = FileModule->CloseQuery();
   }

void __fastcall TMainForm::ToolButton1Click(TObject *Sender)
   {
   RichEdit->Print(Application->Title);
   }

